% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explanations.R
\name{describeInstance}
\alias{describeInstance}
\title{Explain the instance/outlier by a brief textual summary}
\usage{
describeInstance(data, model, instanceIndex, topN = 10)
}
\arguments{
\item{data}{data.frame with data describing all instances}

\item{model}{outlier detection model}

\item{instanceIndex}{index of the instance to visualize}

\item{topN}{limit for a print of top matching frequent itemsets}
}
\description{
Explain the instance/outlier by a brief textual summary
}
\examples{
library("fpmoutliers")
dataFrame <- read.csv(
     system.file("extdata", "fp-outlier-customer-data.csv", package = "fpmoutliers"))
model <- FPI(dataFrame, minSupport = 0.001)
# sort data by the anomaly score
dataFrame <- dataFrame[order(model$scores, decreasing = TRUE),]
# instance with the highest anomaly score
describeInstance(dataFrame, model, 1)
# instance with the lowest anomaly score
describeInstance(dataFrame, model, nrow(dataFrame))
}
