% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mBm_mGn.R
\name{mBm_mGn}
\alias{mBm_mGn}
\title{Multifractional Brownian motion and multifractional Gaussian noise}
\usage{
mBm_mGn(N, Ht)
}
\arguments{
\item{N}{The length of sample time series to simulate.}

\item{Ht}{The N by 1 vector of the time evolving H(t).}
}
\value{
The object returned from the function includes:
\itemize{
 \item mBm: multifractional Brownian motion
 \item mGn: multifractional Gaussian noise
}
}
\description{
Simulate multifractional Brownian motion and multifractional Gaussian noise.
}
\details{
This is an algorithm that simulates discrete time multifractional 
Brownian motion and multifractional Gaussian noise, which can useful for 
testing various functions within the `fractalRegression` package. H(t) 
should take on any values between 0 and 1. It is meant to capture time 
varying fractal properties. The example code given below shows a slow 
evolving Hurst exponent involving a sinusoidal change.
}
\examples{

t <- 1:1024
Ht <- 0.5+0.5*(sin(0.0025*pi*t))
sim <- mBm_mGn(1024,Ht)



}
