% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vfractional.R
\name{vfractional}
\alias{vfractional}
\title{Vectorized form for fractional}
\usage{
vfractional(x, eps = 1e-06, maxConv = 20)
}
\arguments{
\item{x}{as for \code{fractional}}

\item{eps}{as for \code{fractional}, but may be a vector}

\item{maxConv}{as for \code{fractional} but may be a vector}
}
\value{
A character string vector of class \code{"charFrac"}
}
\description{
A function which allows any or all of the first three
arguments of \code{fractional} to be vectors, with short
vectors recycled in the usual way.  Note that the return
value is a \emph{character string} vector and may not be
used in arithmetic operations
}
\examples{
oldOpt <- options(scipen = 15)
pi_approx <- vfractional(base::pi, eps = 0, maxConv = 1:10)
within(data.frame(pi_approx, stringsAsFactors = FALSE), {
  value = numerical(pi_approx)
  error = signif(base::pi - value, 3)
  n = seq_along(value) - 1
})[, c("n", "pi_approx", "value", "error")]
options(oldOpt)
}

