% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_category.R
\name{fredr_category}
\alias{fredr_category}
\title{Get a FRED category}
\usage{
fredr_category(category_id = 0L)
}
\arguments{
\item{category_id}{An integer ID for the category.  Default is \code{0} for the
root category. \emph{Required parameter.}}
}
\value{
A \code{tibble} object containing the name and parent ID for the category
indicated by \code{category_id}.
}
\description{
Get a FRED category
}
\section{API Documentation}{


\href{https://research.stlouisfed.org/docs/api/fred/category.html}{fred/category}
}

\examples{
\donttest{
# Root category
fredr_category()
# "Production & Business Activity" category
fredr_category(category_id = 1L)
}
}
\seealso{
\code{\link[=fredr_category_children]{fredr_category_children()}}, \code{\link[=fredr_category_related]{fredr_category_related()}},
\code{\link[=fredr_category_series]{fredr_category_series()}}, \code{\link[=fredr_category_tags]{fredr_category_tags()}}, \code{\link[=fredr_category_related_tags]{fredr_category_related_tags()}}
}
