% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_release_sources.R
\name{fredr_release_sources}
\alias{fredr_release_sources}
\title{Get the sources for a release of economic data}
\usage{
fredr_release_sources(release_id = NULL, realtime_start = NULL,
  realtime_end = NULL)
}
\arguments{
\item{release_id}{An integer ID of the release. \emph{Required parameter.}}

\item{realtime_start}{A \code{Date} indicating the start of the real-time period.
Defaults to today's date. For more information, see
\href{https://research.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}

\item{realtime_end}{A \code{Date} indicating the end of the real-time period.
Defaults to today's date. For more information, see
\href{https://research.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}
}
\value{
A \code{tibble} object.
}
\description{
Get the sources for a release of economic data
}
\section{API Documentation}{


\href{https://research.stlouisfed.org/docs/api/fred/release_sources.html}{fred/release/sources}
}

\examples{
\donttest{
# Where does the data for ID 10 come from?
fredr_release_sources(release_id = 10L)
}
}
\seealso{
\code{\link[=fredr_releases]{fredr_releases()}}, \code{\link[=fredr_releases_dates]{fredr_releases_dates()}}, \code{\link[=fredr_release]{fredr_release()}},
\code{\link[=fredr_release_dates]{fredr_release_dates()}}, \code{\link[=fredr_release_series]{fredr_release_series()}}, \code{\link[=fredr_release_tags]{fredr_release_tags()}},
\code{\link[=fredr_release_related_tags]{fredr_release_related_tags()}}, \code{\link[=fredr_release_tables]{fredr_release_tables()}}
}
