% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/timedom.trunc.R
\name{timedom.trunc}
\alias{timedom.trunc}
\title{Truncates a time domain object to specified lags}
\usage{
timedom.trunc(A, lags)
}
\arguments{
\item{A}{\code{timedom} object - series of operators}

\item{lags}{lags to which A should be truncated}
}
\value{
Truncated time series
}
\description{
Truncates a time domain object to specified lags (equivalent to setting the lags to zero)
}
\examples{
X = rar(100)
Y = rar(100)
#estimate regressors in model $Y_t = \\sum_{i\\in Z} A_i X_{t-i}$
A = speclagreg(X,Y)
B = timedom.trunc(A, c(-1, 2, 3))
}

