% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/pcafreq.R
\name{pcafreq}
\alias{.pcafreq}
\alias{pcafreq}
\title{Principal Component Analysis}
\usage{
pcafreq(data, freq = NULL, scale.unit = TRUE, ncp = 5, quantisup = NULL,
  qualisup = NULL, colw = NULL, graph = TRUE, axes = c(1, 2))

.pcafreq(tfq, scale.unit = TRUE, ncp = 5, quantisup = NULL,
  qualisup = NULL, colw = NULL, graph = TRUE, axes = c(1, 2))
}
\arguments{
\item{data}{a data frame}

\item{freq}{a name of the variable specifying frequency weights}

\item{scale.unit}{a boolean, if TRUE (value set by default) then data are scaled to unit variance}

\item{ncp}{number of dimensions kept in the results}

\item{quantisup}{a vector indicating the names of the quantitative supplementary variables}

\item{qualisup}{a vector indicating the names of the categorical supplementary variables}

\item{colw}{an optional column weights (by default, uniform column weights)}

\item{graph}{boolean, if TRUE a graph is displayed}

\item{axes}{a length 2 vector specifying the components to plot}

\item{tfq}{a table of frequencies}
}
\value{
It returns a list described in \code{\link[FactoMineR]{PCA}}.
}
\description{
It computes a principal component analysis with sumplementary quantitative and qualitative variables. It is wrapper of \code{\link[FactoMineR]{PCA}}.
}
\details{
This function calls \code{\link[FactoMineR]{PCA}} with the the frequency weights as \code{row.w}. Any variable present in \code{freq} are removed from the data.
}
\examples{
pcafreq(iris,  qualisup="Species", graph=TRUE)

tfq <- tablefreq(iris)
.pcafreq(tfq,  qualisup="Species", graph=TRUE)
}
\seealso{
\code{\link[FactoMineR]{PCA}}, \code{link{tablefreq}}
}

