% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-bootstrap.R
\name{bs_vars_nav}
\alias{bs_vars_nav}
\title{Bootstrap nav variables}
\usage{
bs_vars_nav(
  link_padding = NULL,
  link_hover_bg = NULL,
  disabled_link_color = NULL,
  disabled_link_hover_color = NULL
)
}
\arguments{
\item{link_padding}{Padding for links (tabset's titles).}

\item{link_hover_bg}{Link hover background color.}

\item{disabled_link_color}{Disabled link color.}

\item{disabled_link_hover_color}{Disabled link hover color.}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
Those variables can be used to customize
 navs (e.g. \code{\link[shiny:tabsetPanel]{shiny::tabsetPanel}} or
 \code{\link[shiny:navlistPanel]{shiny::navlistPanel}}) in Bootstrap and Bootswatch themes.
}
\note{
See \code{\link{bs_vars_pills}} and \code{\link{bs_vars_tabs}} for more options.
}
\examples{
# Change color of tabset when hovered
bs_vars_nav(
  link_padding = "30px 45px",
  link_hover_bg = "#FF0000"
)

if (interactive()) {
  library(shiny)
  library(fresh)

  ui <- fluidPage(

    use_theme(create_theme(
      theme = "default",
      bs_vars_nav(
        link_padding = "30px 45px",
        link_hover_bg = "#FF0000"
      )
    )),

    tags$h1("State variables"),
    fluidRow(
      column(
        width = 6,
        navlistPanel(
          "Header",
          tabPanel("First"),
          tabPanel("Second"),
          tabPanel("Third")
        )
      ),
      column(
        width = 6,
        tabsetPanel(
          tabPanel("Plot", plotOutput("plot")),
          tabPanel("Summary", verbatimTextOutput("summary")),
          tabPanel("Table", tableOutput("table"))
        )
      )
    )
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)
}
}
