% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_resource.R
\name{remove_resource}
\alias{remove_resource}
\title{Remove a Data Resource}
\usage{
remove_resource(package, resource_name)
}
\arguments{
\item{package}{List describing a Data Package, created with \code{\link[=read_package]{read_package()}}
or \code{\link[=create_package]{create_package()}}.}

\item{resource_name}{Name of the Data Resource.}
}
\value{
Provided \code{package} with one fewer resource.
}
\description{
Removes a \href{https://specs.frictionlessdata.io/data-resource/}{Data Resource}
from a Data Package, i.e. it removes one of the described \code{resources}.
}
\examples{
# Load the example Data Package
package <- example_package

# List resources
resources(package)

# Remove the resource "observations"
package <- remove_resource(package, "observations")

# List resources ("observations" removed)
resources(package)
}
\seealso{
Other edit functions: 
\code{\link{add_resource}()},
\code{\link{get_schema}()}
}
\concept{edit functions}
