% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access.R
\name{file_access}
\alias{file_access}
\alias{file_exists}
\alias{dir_exists}
\alias{link_exists}
\title{Query for existence and access permissions}
\usage{
file_access(path, mode = "exists")

file_exists(path)

dir_exists(path)

link_exists(path)
}
\arguments{
\item{path}{A character vector of one or more paths.}

\item{mode}{A character vector containing one or more of 'exists', 'read',
'write', 'execute'.}
}
\value{
A logical vector, with names corresponding to the input \code{path}.
}
\description{
\code{file_exists(path)} is a shortcut for \code{file_access(x, "exists")};
\code{dir_exists(path)} and \code{link_exists(path)} are similar but also check that
the path is a directory or link, respectively.
}
\examples{
file_access("/")
file_access("/", "read")
file_access("/", "write")

file_exists("WOMBATS")
}
