% Generated by roxygen2 (4.0.2): do not edit by hand
\name{ortho2}
\alias{ortho2}
\title{Orthographic Display, added options}
\usage{
ortho2(x, y = NULL, xyz = NULL, w = 1, col = gray(0:64/64),
  col.y = hotmetal(), zlim = NULL, zlim.y = NULL, crosshairs = TRUE,
  col.crosshairs = "red", xlab = "", ylab = "", axes = FALSE,
  oma = rep(0, 4), mar = rep(0, 4), bg = "black", text = NULL,
  text.color = "white", text.cex = 2, text.x = 32, text.y = 32,
  add.orient = TRUE, mfrow = c(2, 2), ybreaks = NULL, addlegend = FALSE,
  leg.x = 32, leg.y = 32, legend, leg.col, leg.title = NULL, leg.cex,
  window = NULL, ...)
}
\arguments{
\item{x}{is an object of class nifti or similar.}

\item{y}{is an object of class nifti or similar for the overlay.}

\item{xyz}{is the coordinate for the center of the crosshairs.}

\item{w}{is the time point to be displayed (4D arrays only).}

\item{col}{is grayscale (by default).}

\item{col.y}{is hotmetal (by default).}

\item{zlim}{is the minimum and maximum `z' values passed into image.}

\item{zlim.y}{is the minimum and maximum `z' values passed into image for the overlay.}

\item{crosshairs}{is a logical value for the presence of crosshairs in all three orthogonal planes (default = TRUE).}

\item{col.crosshairs}{is the color of the crosshairs (default = red).}

\item{xlab}{is set to "" since all margins are set to zero.}

\item{ylab}{is set to "" since all margins are set to zero.}

\item{axes}{is set to FALSE since all margins are set to zero.}

\item{oma}{is the size of the outer margins in the par function.}

\item{mar}{is the number of lines of margin in the par function.}

\item{bg}{is the background color in the par function.}

\item{text}{allows the user to specify text to appear in the fourth (unused) pane.}

\item{text.color}{is the color of the user-specified text (default = ``white").}

\item{text.cex}{is the size of the user-specified text (default = 2).}

\item{text.x}{x coordinate for text}

\item{text.y}{y coordinate for text}

\item{add.orient}{(logical) Add left/right, A/P, etc. orientation}

\item{mfrow}{(numeric) layout of the 3 slices}

\item{ybreaks}{(numeric) breaks for y to passed to \code{\link[graphics]{image}}}

\item{addlegend}{(logical) add legend?}

\item{leg.x}{(numeric) x coord for legend}

\item{leg.y}{(numeric) y coord for legend}

\item{legend}{(character) legend text}

\item{leg.col}{(character) Colors for legend}

\item{leg.title}{(character) title for legend}

\item{leg.cex}{(numeric) \code{cex} for \code{\link{legend}}}

\item{window}{(vector) Length-2 vector to limit image to certain range}

\item{...}{other arguments to the image function may be provided here.}
}
\description{
Copy of \code{oro.nifti}'s \code{\link{orthographic}} function with some
tweaks such as adding L/R designations for left and right
}
\seealso{
\link{orthographic}
}

