% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fst.R
\name{write_fst}
\alias{write_fst}
\alias{read_fst}
\alias{write.fst}
\alias{read.fst}
\title{Read and write fst files.}
\usage{
write_fst(x, path, compress = 50, uniform_encoding = TRUE)

read_fst(path, columns = NULL, from = 1, to = NULL,
  as.data.table = FALSE, old_format = FALSE)

write.fst(x, path, compress = 50, uniform_encoding = TRUE)

read.fst(path, columns = NULL, from = 1, to = NULL,
  as.data.table = FALSE, old_format = FALSE)
}
\arguments{
\item{x}{a data frame to write to disk}

\item{path}{path to fst file}

\item{compress}{value in the range 0 to 100, indicating the amount of compression to use.}

\item{uniform_encoding}{If TRUE, all character vectors will be assumed to have elements with equal encoding.
The encoding (latin1, UTF8 or native) of the first non-NA element will used as encoding for the whole column.
This will be a correct assumption for most use cases.
If \code{uniform.encoding} is set to FALSE, no such assumption will be made and all elements will be converted
to the same encoding. The latter is a relatively expensive operation and will reduce write performance for
character columns.}

\item{columns}{Column names to read. The default is to read all all columns.}

\item{from}{Read data starting from this row number.}

\item{to}{Read data up until this row number. The default is to read to the last row of the stored dataset.}

\item{as.data.table}{If TRUE, the result will be returned as a \code{data.table} object. Any keys set on
dataset \code{x} before writing will be retained. This allows for storage of sorted datasets.}

\item{old_format}{use TRUE to read fst files generated with a fst package version lower than v0.8.0}
}
\value{
\code{read_fst} returns a data frame with the selected columns and rows. \code{read_fst})
invisibly returns \code{x} (so you can use this function in a pipeline).
}
\description{
Read and write data frames from and to a fast-storage (fst) file.
Allows for compression and (file level) random access of stored data, even for compressed datasets.
When using a \code{data.table} object for \code{x}, the key (if any) is preserved,
allowing storage of sorted data.
Methods \code{read_fst} and \code{write_fst} are equivalent to \code{read.fst} and \code{write.fst} (but the
former syntax is preferred).
}
\examples{
# Sample dataset
x <- data.frame(A = 1:10000, B = sample(c(TRUE, FALSE, NA), 10000, replace = TRUE))

# Uncompressed
write_fst(x, "dataset.fst")  # filesize: 41 KB
y <- read_fst("dataset.fst") # read uncompressed data

# Compressed
write_fst(x, "dataset.fst", 100)  # fileSize: 4 KB
y <- read_fst("dataset.fst") # read compressed data

# Random access
y <- read_fst("dataset.fst", "B") # read selection of columns
y <- read_fst("dataset.fst", "A", 100, 200) # read selection of columns and rows
}
