% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GrpDDE.R
\name{GrpDDE}
\alias{GrpDDE}
\title{Group Dipeptide Deviation from Expected Mean}
\usage{
GrpDDE(seqs, Grp = "locFus", label = c())
}
\arguments{
\item{seqs}{is a FASTA file with amino acid sequences. Each sequence starts
with a '>' character. Also, seqs could be a string vector. Each element of the vector is a peptide/protein sequence.}

\item{Grp}{is a list of vectors containig amino acids. Each vector represents a category. Users can define a customized amino acid grouping, provided that the sum of all amino acids is 20 and there is no repeated amino acid in the groups.
Also, users can choose 'cTriad'(conjointTriad), 'locFus', or 'aromatic'. Each option provides specific information about the type of an amino acid grouping.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
A feature matrix with (number of categorizes)^2 number of columns. The number of rows is equal to the number of sequences.
}
\description{
This function is introduced by this package for the first time.
In this function, amino acids are first grouped into user-defined categories.
Later, \link{DDE} is applied to grouped amino acids.
Please note that this function differs from \link{DDE} which works on individual amino acids.
}
\examples{
filePrs<-system.file("extdata/proteins.fasta",package="ftrCOOL")
mat1<-GrpDDE(seqs=filePrs,Grp="aromatic")

mat2<-GrpDDE(seqs=filePrs,Grp=
list(Grp1=c("G","A","V","L","M","I","F","Y","W"),Grp2=c("K","R","H","D","E")
,Grp3=c("S","T","C","P","N","Q")))
}
