% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/funDataMethods.R
\name{meanFunction}
\alias{meanFunction}
\title{Mean for functional data}
\usage{
meanFunction(object, na.rm = FALSE)
}
\arguments{
\item{object}{An object of class \code{funData}, \code{irregFunData} or
\code{multiFunData}.}

\item{na.rm}{Logical. If \code{TRUE}, NA values are removed before computing
  the mean. Defaults to \code{FALSE}.}
}
\value{
An object of the same class as \code{object} with one observation
  that corresponds to the pointwise mean function of the functions in
  \code{object}.
}
\description{
This function calculates the pointwise mean function for objects of class
\code{funData}, \code{irregFunData} or \code{multiFunData}.
}
\section{Warning}{

If \code{object} is of class \code{irregFunData}, the option \code{na.rm =
TRUE} is not implemented and throws an error. If \code{na.rm = FALSE}, the
functions must be observed on the same domain.
}
\examples{
### Univariate (one-dimensional support)
x <- seq(0, 2*pi, 0.01)
f1 <- funData(x, outer(seq(0.75, 1.25, 0.05), sin(x)))

plot(f1)
plot(meanFunction(f1), col = 1, lwd = 2, add = TRUE)

### Univariate (two-dimensional support)
f2 <- funData(list(1:5, 1:3), array(rep(1:5,each = 11, times = 3), dim = c(11,5,3)))
all.equal(extractObs(f2,1), meanFunction(f2)) # f2 has 11 identical observations

### Multivariate
m1 <- multiFunData(f1,f2)
all.equal(extractObs(m1, obs = 6), meanFunction(m1)) # observation 6 equals the pointwise mean

### Irregular
i1 <- irregFunData(argvals = list(1:3,1:3,1:3), X = list(1:3,2:4,3:5))
all.equal(meanFunction(i1), extractObs(i1, obs = 2))
# don't run: functions are not defined on the same domain
\dontrun{meanFunction(irregFunData(argvals = list(1:3,1:5), X = list(1:3,1:5))) }
}
\seealso{
\code{\linkS4class{funData}}, \code{\linkS4class{irregFunData}},
  \code{\linkS4class{multiFunData}}, \code{\link{Arith.funData}}
}

