% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce.R
\name{fd2funData}
\alias{fd2funData}
\title{Convert an fd object to funData}
\usage{
fd2funData(fdobj, argvals, ...)
}
\arguments{
\item{fdobj}{An \code{fd} object}

\item{argvals}{A vector or a list of length one, containing a vector
with argument values at which the functions in \code{fdobj} should be
evaluated.}

\item{...}{Other parameters passed to \code{\link[fda]{eval.fd}}.}
}
\value{
An object of class \code{\link{funData}}.
}
\description{
This function converts an object of class \code{\link[fda]{fd}} (from
package \pkg{fda}) to an object of class \code{\link{funData}}. It
heavily builds on the function \code{\link[fda]{eval.fd}} from the
\pkg{fda} package. The \code{\link[fda]{fd}} representation assumes a
basis representation for the observed functions and therefore
implicitly smoothes the data. In \code{funData} objects, the data is
saved in 'raw' format.
}
\section{Warning}{
 Time names in \code{fdobj$fdnames$time} are not
  preserved.
}

\examples{
# Install / load package fda before running the examples
library("fda")

# from Data2fd help
daybasis <- create.fourier.basis(c(0, 365), nbasis=65)
# fd object of daily temperatures
tempfd <- Data2fd(argvals = day.5, y = CanadianWeather$dailyAv[,,"Temperature.C"], daybasis)
# convert to funData
tempFun <- fd2funData(tempfd, argvals = day.5)

# plot to compare
par(mfrow = c(1,2))
plot(tempfd, main = "fd object")
plot(tempFun, main = "funData object") 
}
\seealso{
\code{\linkS4class{funData}}, \code{\link[fda]{fd}},
  \code{\link[fda]{eval.fd}}
}
