%
%  Copyright (C) 2011-2015 Christina Yassouridis
% 
%

\name{sampleFuncy}
\alias{sampleFuncy}
\alias{Cluster,sampleFuncy-method}
\alias{Data}
\alias{Data,sampleFuncy-method}

\title{
Simulate functional data.
}
\description{
  Generates a functional dataset for 2-6  clusters.
}
\usage{
sampleFuncy(obsNr=100, k=4, timeNr=20, timeNrMax=NULL,
            timeNrMin=NULL, timeInterval=c(0, 1),
            nrGridPts=30, sd=0.3, reg=TRUE)
\S4method{Cluster}{sampleFuncy}(object)
\S4method{Data}{sampleFuncy}(object,\dots)
}
\arguments{
  \item{obsNr}{
    Number of curves.
  }
  \item{k}{
    Number of classes.
  }
  \item{timeNr}{
    Number of time points for regular datasets in Format2 (see \code{\link{funcit}}).
  }
  \item{timeNrMax}{
    Maximal number of time points for irregular datasets in Format1 (see \code{\link{funcit}}).
  }
  \item{timeNrMin}{
    Minimal number of time points for irregular dataset in Format1 (see \code{\link{funcit}}).
  }
  \item{timeInterval}{
    Time interval where time points are drawn from. 
  }
  \item{nrGridPts}{
    Time interval is divided into nrGridPts grid points where time points are
    randomly drawn from. 
  }
  \item{sd}{
    Standard deviation from the center curves. 
  }
  \item{reg}{
    Regular dataset in Format2 or irregular dataset in Format1 (see \code{\link{funcit}}).
  }
  \item{object}{
    An object of class \code{\link{sampleFuncy}}
  }
  \item{\dots}{
    Not used.
  }
}
\details{
  Curves are generated by adding a normally distributed error term with
  mean 0 and standard deviation sd to the
  center functions. The center functions are sampled from
  \itemize{
  \item
  \eqn{x^2}
  \item \eqn{\sqrt{x}}
  \item
  \eqn{sin(2*\pi*x)}
  \item
  \eqn{x^3}
  \item
  \eqn{-x^2}
  \item
  \eqn{x-1}
  }
  If \code{reg}=\code{TRUE} all curves are
evaluated on the same time points. If \code{reg}=\code{FALSE} evaluation place
and number can differ for each curve.
}

\value{
  \itemize{
    \item[sampleFuncy]
    A list with entries \code{data} and \code{clusters}.
    \item[Cluster]
    Retrieve vector of cluster assignments
    \item[Data]
    Retrieve matrix of dataset
  }
}

\author{
  Christina Yassouridis
}

\seealso{
  \code{\link{funcit}}
}
\examples{
##sample a regular dataset
set.seed(2705)
ds <- sampleFuncy(obsNr=100, k=4, timeNr=20, reg=TRUE)
plotFuncy(ds)

##sample an irregular dataset
set.seed(2705)
ds <- sampleFuncy(obsNr=100, k=4, timeNrMin=3, timeNrMax=10, reg=FALSE)
plotFuncy(ds, lty=1)

}


\keyword{datasets}
