% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fareg.R
\name{fareg}
\alias{fareg}
\title{Regularized Factor Analysis}
\usage{
fareg(R, numFactors = 1, facMethod = "rls")
}
\arguments{
\item{R}{(Matrix) A correlation matrix to be analyzed.}

\item{numFactors}{(Integer) The number of factors to extract. Default: numFactors = 1.}

\item{facMethod}{(Character) "rls" for regularized least squares estimation or 
"rml" for regularized maximum likelihood estimation. Default: facMethod = "rls".}
}
\value{
The main output is the matrix of unrotated factor loadings.
\itemize{
  \item \strong{loadings}: (Matrix) A matrix of unrotated factor loadings.
  \item \strong{h2}: (Vector) A vector of estimated communality values.
  \item \strong{L}: (Numeric) Value of the estimated penality parameter.
  \item \strong{Heywood} (Logical) TRUE if a Heywood case is detected 
               (this should never happen).
  }
}
\description{
This function applies the regularized factoring method to extract an unrotated factor structure matrix.
}
\examples{

data("HW")

# load first HW data set

RHW <- cor(x = HW$HW6)

# Compute principal axis factor analysis
fapaOut <- faMain(R = RHW, 
                 numFactors = 3, 
                 facMethod = "fapa", 
                 rotate = "oblimin",
                 faControl = list(treatHeywood = FALSE))


fapaOut$faFit$Heywood
round(fapaOut$h2, 2)

 # Conduct a regularized factor analysis
regOut <- fareg(R = RHW, 
               numFactors = 3,
               facMethod = "rls")
regOut$L
regOut$Heywood


# rotate regularized loadings and align with 
# population structure
regOutRot <- faMain(urLoadings = regOut$loadings,
                   rotate = "oblimin")

# ALign
FHW  <- faAlign(HW$popLoadings, fapaOut$loadings)$F2
Freg <- faAlign(HW$popLoadings, regOutRot$loadings)$F2

AllSolutions <- round(cbind(HW$popLoadings, Freg, FHW),2) 
colnames(AllSolutions) <- c("F1", "F2", "F3", "Fr1", "Fr2", "Fr3", 
                           "Fhw1", "Fhw2", "Fhw3")
AllSolutions


rmsdHW <- rmsd(HW$popLoadings, FHW, 
              IncludeDiag = FALSE, 
              Symmetric = FALSE)

rmsdReg <- rmsd(HW$popLoadings, Freg, 
               IncludeDiag = FALSE, 
               Symmetric = FALSE)

cat("\\nrmsd HW =  ", round(rmsdHW,3),
    "\\nrmsd reg = ", round(rmsdReg,3))



}
\references{
Jung, S. & Takane, Y.  (2008).  Regularized common factor analysis.  
New trends in psychometrics, 141-149.
}
\seealso{
Other Factor Analysis Routines: 
\code{\link{BiFAD}()},
\code{\link{Box26}},
\code{\link{GenerateBoxData}()},
\code{\link{Ledermann}()},
\code{\link{SLi}()},
\code{\link{SchmidLeiman}()},
\code{\link{faAlign}()},
\code{\link{faEKC}()},
\code{\link{faMain}()},
\code{\link{faScores}()},
\code{\link{faSort}()},
\code{\link{faStandardize}()},
\code{\link{faX}()},
\code{\link{fals}()},
\code{\link{fapa}()},
\code{\link{orderFactors}()},
\code{\link{print.faMain}()},
\code{\link{promaxQ}()},
\code{\link{summary.faMain}()}
}
\author{
Niels G. Waller (nwaller@umn.edu)
}
\concept{Factor Analysis Routines}
