% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosMAT.R
\name{cosMat}
\alias{cosMat}
\title{Compute the cosine(s) between either 2 matrices or 2 vectors.}
\usage{
cosMat(A, B, align = FALSE, digits = NULL)
}
\arguments{
\item{A}{(Matrix, Vector) Either a matrix or vector.}

\item{B}{(Matrix, Vector) Either a matrix or vector (must be of the same dimensions as A).}

\item{align}{(Logical) Whether to run a factor alignment before computing the cosine.}

\item{digits}{(Numeric) The number of digits to round the output to.}
}
\value{
A vector of cosines will be returned. When comparing two vectors, only one cosine can be computed. When comparing matrices, one cosine is computed per column.
\itemize{
  \item \strong{cosine}: (Matrix) A matrix of cosines between the two inputs. 
  \item \strong{A}: (Matrix) The A input matrix.
  \item \strong{B}: (Matrix) The B input matrix. 
  \item \strong{align}: (Logical) Whether Matrix B was aligned to A.
}
}
\description{
This function will compute the cosines (i.e., the angle) between two vectors or matrices. When applied to matrices, it will compare the two matrices one vector (i.e., column) at a time. For instance, the cosine (angle) between factor 1 in matrix A and factor 1 in matrix B.
}
\details{
\itemize{
  \item \strong{Chance Congruence}: Factor cosines were originally described by Burt (1948) and later popularized by Tucker (1951). Several authors have noted the tendency for two factors to have spuriously large factor cosines. Paunonen (1997) provides a good overview and describes how factor cosines between two vectors of random numbers can appear to be congruent.
  \item \strong{Effect Size Benchmarks}: When computing congruence coefficients (cosines) in factor analytic studies, it can be useful to know what constitutes large versus small congruence. Lorenzo-Seva and ten Berge (2006) currently provide the most popular (i.e., most frequently cited) recommended benchmarks for congruence. ``A value in the range .85-.94 means that the two factors compared display \emph{fair} similarity. This result should prevent congruence below .85 from being interpreted as indicative of any factor similarity at all. A value higher than .95 means that the two factors or components compared can be considered equal. That is what we have called a \emph{good} similarity in our study'' (Lorenzo-Seva & ten Berge, 2006, p. 61, emphasis theirs).
}
}
\examples{
## Cosine between two vectors
A <- rnorm(5)
B <- rnorm(5)

cosMat(A, B)

## Cosine between the columns of two matrices
A <- matrix(rnorm(5 * 5), 5, 5)
B <- matrix(rnorm(5 * 5), 5, 5)

cosMat(A, B)

}
\references{
Burt, C. (1948). The factorial study of temperament traits. \emph{British Journal of Psychology, Statistical Section, 1}, 178-203.

Lorenzo-Seva, U., & ten Berge, J. M. F. (2006). Tuckers Congruence Coefficient as a meaningful index of factor similarity. \emph{Methodology, 2}(2), 57-64.

Paunonen, S. V. (1997). On chance and factor congruence following orthogonal Procrustes rotation. \emph{Educational and Psychological Measurement}, 57, 33-59.

Tucker, L. R. (1951). \emph{A method for synthesis of factor analysis studies} (Personnel Research Section Report No. 984). Washington, DC: Department of the Army.
}
\author{
\itemize{
  \item Casey Giordano (Giord023@umn.edu)
  \item Niels G. Waller (nwaller@umn.edu)
}
}
