% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verify_row_info.R
\name{verify_row_info}
\alias{verify_row_info}
\title{Verify the integrity of the row info object}
\usage{
verify_row_info(row_info, data)
}
\arguments{
\item{row_info}{A data frame describing the rows of \code{data}.
This data should contain two columns:
\itemize{
\item \code{id} (\code{character}): Corresponds to the column \code{data$id}.
\item \code{group} (\code{character}): The group of the row.
If all are \code{NA}, the rows will not be split up into groups.
}}

\item{data}{A data frame with items by row and features in the columns.
Must contain one column named \code{"id"}.}
}
\value{
The row info object with all expected columns.
}
\description{
Verify the integrity of the row info object
}
\examples{
library(tibble)
data <- tribble(
  ~id, ~name, ~x, ~y,
  "foo1", "Foo1", 0.5, 0.7,
  "foo2", "Foo2", 0.5, 0.8,
  "bar1", "Bar1", 1.0, 0.2,
  "bar2", "Bar2", 1.0, 0.1
)
row_info <- tribble(
  ~id, ~group,
  "foo1", "foo",
  "foo2", "foo",
  "bar1", "bar",
  "bar2", "bar"
)
verify_row_info(row_info, data)
}
