% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/future_options.R
\name{future_options}
\alias{future_options}
\title{\code{future} specific options}
\usage{
future_options(globals = TRUE, packages = NULL, seed = FALSE,
  lazy = FALSE, scheduling = 1)
}
\arguments{
\item{globals}{A logical, a character vector, or a named list for
controlling how globals are handled. For details, see \code{Global variables and packages}.}

\item{packages}{(optional) a character vector specifying packages
to be attached in the R environment evaluating the future.}

\item{seed}{A logical or an integer (of length one or seven),
or a list of \code{length(.x)} with pre-generated random seeds.
For details, see below section.}

\item{lazy}{Specifies whether the futures should be resolved
lazily or eagerly (default).}

\item{scheduling}{Average number of futures ("chunks") per worker.
If \code{0.0}, then a single future is used to process all elements
of \code{.x}.
If \code{1.0} or \code{TRUE}, then one future per worker is used.
If \code{2.0}, then each worker will process two futures
(if there are enough elements in \code{.x}).
If \code{Inf} or \code{FALSE}, then one future per element of
\code{.x} is used.}
}
\description{
These options are used by \code{future()} internally to tweak the environment that
the expressions are called in. The most important ones are \code{globals} and
\code{packages} which allow you to be explicit about the variables and packages
that are exported to each worker.
}
\section{Global variables and packages}{


By default, the \code{future} package will perform black magic to look up the
global variables and packages that your \code{furrr} call requires, and it
will export these to each worker. However, it is not always perfect, and
can be refined with the \code{globals} and \code{packages} arguments.

\code{globals} may be used to control how globals
should be handled similarly how the \code{globals} argument is used with
\code{future()}. Since all function calls use the same set of globals, this function can do
any gathering of globals upfront (once), which is more efficient than if
it would be done for each future independently.
\itemize{
\item If \code{TRUE} or \code{NULL}, then globals are automatically identified and gathered.
\item If a character vector of names is specified, then those globals are gathered.
\item If a named list, then those globals are used as is.
\item In all cases, \code{.f} and any \code{...} arguments are automatically
passed as globals to each future created as they are always needed.
}

\code{packages} may be used to control the packages that are exported
to each worker.
\itemize{
\item If a character vector of packages names is specified, those are exported
to each worker.
\item In all cases, \code{purrr} is exported, as it is always required on each worker.
}
}

\section{Reproducible random number generation (RNG)}{


Unless \code{seed = FALSE}, this function guarantees to generate
the exact same sequence of random numbers \emph{given the same initial
seed / RNG state} - this regardless of type of futures and scheduling
("chunking") strategy.

RNG reproducibility is achieved by pregenerating the random seeds for all
iterations (over \code{.x}) by using L'Ecuyer-CMRG RNG streams.  In each
iteration, these seeds are set before calling \code{.f(.x[[ii]], ...)}.
\emph{Note, for large \code{length(.x)} this may introduce a large overhead.}

As input (\code{seed}), a fixed seed (integer) may be given, either
as a full L'Ecuyer-CMRG RNG seed (vector of 1+6 integers) or as a seed
generating such a full L'Ecuyer-CMRG seed.
If \code{seed = TRUE}, then \code{\link[base:Random]{.Random.seed}}
is returned if it holds a L'Ecuyer-CMRG RNG seed, otherwise one is created
randomly.
If \code{seed = NA}, a L'Ecuyer-CMRG RNG seed is randomly created.
If none of the function calls \code{.f(.x[[ii]], ...)} uses random number
generation, then \code{seed = FALSE} may be used.

In addition to the above, it is possible to specify a pre-generated
sequence of RNG seeds as a list such that
\code{length(seed) == length(.x)} and where each element is an
integer seed that can be assigned to \code{\link[base:Random]{.Random.seed}}.
Use this alternative with caution.
\strong{Note that \code{as.list(seq_along(.x))} is \emph{not} a valid set of such
\code{.Random.seed} values.}

In all cases but \code{seed = FALSE}, the RNG state of the calling
R processes after this function returns is guaranteed to be
"forwarded one step" from the RNG state that was before the call and
in the same way regardless of \code{seed}, \code{scheduling}
and future strategy used.  This is done in order to guarantee that an \R
script calling \code{future_map()} multiple times should be numerically
reproducible given the same initial seed.
}

