% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inflate.R
\name{inflate}
\alias{inflate}
\title{Inflate Rmd to package}
\usage{
inflate(
  pkg = ".",
  rmd = file.path("dev", "dev_history.Rmd"),
  name = "exploration",
  check = TRUE,
  document = TRUE
)
}
\arguments{
\item{pkg}{Path to package}

\item{rmd}{Path to Rmarkdown file to inflate}

\item{name}{Name of the resulting vignette}

\item{check}{Logical. Whether to check package after Rmd inflating}

\item{document}{Logical. Whether to document your package using \code{\link[attachment:att_amend_desc]{att_amend_desc}}}
}
\value{
Package structure. Return path to current package.
}
\description{
Inflate Rmd to package
}
\examples{
# Create a new project
tmpdir <- tempdir()
dummypackage <- file.path(tmpdir, "dummypackage")
dir.create(dummypackage)

# {fusen} steps
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))
dev_file <- add_dev_history(pkg = dummypackage, overwrite = TRUE)
inflate(pkg = dummypackage, rmd = dev_file, name = "Exploration of my Data", check = FALSE)

# Explore directory of the package
# browseURL(dummypackage)

# Try pkgdown build
# pkgdown::build_site(dummypackage)
# usethis::use_build_ignore("docs")
# usethis::use_git_ignore("docs")
# Delete dummy package
unlink(dummypackage, recursive = TRUE)
}
