# WARNING - Generated by {fusen} from dev/flat_init_share_on_github.Rmd: do not edit by hand

#' Initiate GitHub to share your package on a website
#'
#' This uses 'pkgdown' to share the documentation of the package through GitHub Actions.
#' You may need to run `usethis::create_github_token()`, then `gitcreds::gitcreds_set()` before.
#'
#' @param ask Logical. `TRUE` (default) to ask the user to apply the instructions each time needed,
#' or `FALSE` if the user already know what to do.
#' @inheritParams usethis::use_github
#'
#' @details
#'
#' `init_share_on_github()` runs multiple steps to be able to share a proper package on GitHub:
#'
#' - Start versionning with git if not already
#' - Connect to your GitHub account
#' - Create a minimal DESCRIPTION file if missing
#'   + You will have to update its content with your information after deployment
#' - Add NEWS file to present modifications of your releases
#' - Add README.Rmd and knit it to README.md to quickly present the aim and the use of your package
#' - Init continuous integration (CI)
#'   + Check the package on Linux, Windows and MacOS
#'   + Calculate code coverage. Note that you may need to connect to <https://about.codecov.io/> to see the results of the code coverage.
#' - Init continuous deployment (CD) of the 'pkgdown' website documentation
#' - Commit and push to GitHub
#' - List remaining manual steps to make the website public
#'
#' Read `vignette("share-on-a-github-website", package = "fusen")`
#'
#' @return The URL of the website created
#' @export
#'
#' @examples
#' \dontrun{
#' # This modifies the current directory and send it on GitHub
#' init_share_on_github()
#' }
init_share_on_github <- function(ask = TRUE, organisation = NULL) {
  pkg <- "."

  if (!requireNamespace("gert", quietly = TRUE)) {
    stop("Please install the {gert} package to be able to share on GitHub as you will need to use git and commit.")
  }
  if (!requireNamespace("knitr", quietly = TRUE)) {
    stop("Please install the {knitr} package to be able to share on GitHub as you will need to knit your README.")
  }

  # Init git if not already initiated
  repo <- tryCatch(gert::git_find(pkg), error = function(e) NULL)
  if (!is.null(repo)) {
    to_init <- is.na(gert::git_info(pkg)[["head"]])
  } else {
    to_init <- TRUE
  }
  if (to_init) {
    if (isTRUE(ask)) {
      sure <- paste0(
        "git is not initiated yet\n",
        "Do you want to init and commit the current state? (y/n)\n"
      )
      do_it <- readline(sure) == "y"
    } else {
      do_it <- TRUE
    }
    if (do_it) {
      cli::cat_rule("Init Git Repository with first commit")
      gert::git_init(path = pkg)
      gert::git_add(".")
      gert::git_commit_all(message = "chore: Init repository")
      if (requireNamespace("rstudioapi") && rstudioapi::isAvailable()) {
        message("After the procedure, you'll want to restart your RStudio session")
      }
    } else {
      stop("Please Init you git repository using `usethis::use_git()`")
    }
  }

  # Init GitHub connexion
  cli::cat_rule("Init GitHub Connexion")
  info_git <- gert::git_remote_list()
  if (nrow(info_git) == 0) {
    if (isTRUE(ask)) {
      sure <- paste0(
        "You may be redirected on GitHub. \nDo not forget to come back here, ok? (y/n)\n"
      )
      do_it <- readline(sure) == "y"
    } else {
      dont_do_it <- FALSE
    }
    if (do_it) {
      usethis::use_github(organisation = organisation)
    } else {
      cli::cli_text(
        cli::cli_alert_info(
          "You decided to stop the procedure. \nYour package was not send to {.url https://github.com}",
          "\nYou can run again {.fn fusen::init_share_on_github} to finish the procedure if you want."
        )
      )
      return(NULL)
    }
  } else if (grepl("github", info_git[info_git$name == "origin", "url"])) {
    message(
      "Your repository is already connected to a remote GitHub repository: ",
      info_git[info_git$name == "origin", "url"]
    )
  } else {
    stop("Your repository is not connected to a GitHub repository: ", info_git[info_git$name == "origin", "url"])
  }

  msg <- character(0)

  # Add a DESCRIPTION if not exists
  if (!file.exists("DESCRIPTION")) {
    cli::cat_rule("Add DESCRIPTION")
    fill_description(pkg = pkg)
    msg <- c(msg, "You need to fill your DESCRIPTION file. See `?fusen::fill_description`.")
  }

  # Add a NEWS if not exists
  if (!file.exists("NEWS.md")) {
    cli::cat_rule("Add NEWS")
    usethis::use_news_md()
  }

  # Add a Readme if not exists
  if (!file.exists("README.Rmd")) {
    cli::cat_rule("Add Readme")
    usethis::use_readme_rmd()
  }

  # Add GitHub Actions with pkgdown
  cli::cat_rule("Init GitHub Actions")
  usethis::use_github_action("check-standard")
  usethis::use_github_action("pkgdown")
  usethis::use_github_action("test-coverage")
  usethis::use_coverage(type = "codecov")

  # Get info for website
  github_url <- gert::git_remote_info()$url
  github_url_no_git <- gsub("[.]git$", "", github_url)
  username <- gsub("https://github.com/(.*)/.*$", "\\1", github_url_no_git)
  projname <- gsub(paste0("https://github.com/", username, "/(.*)$"), "\\1", github_url_no_git)
  url_pages <- paste0("https://", username, ".github.io/", projname)

  # Knit the Readme file
  cli::cat_rule("Update and Knit the Readme file")
  readme_lines <- readLines("README.Rmd")
  add_line <- grep("## Example", readme_lines)[1]
  readme_lines[add_line] <- paste0(
    "## Documentation\n\n",
    "Full documentation website on: ", url_pages,
    "\n\n",
    readme_lines[add_line]
  )
  cat(readme_lines, file = "README.Rmd", sep = "\n")
  knitr::knit("README.Rmd")
  msg <- c(msg, "You will want to update your README.Rmd file. And then `knit()` it.")

  # Push to the repository
  cli::cat_rule("Push to GitHub and wait for publication")
  gert::git_add(".")
  gert::git_commit_all(message = "chore: Init Actions and website")
  gert::git_push()

  # Message website
  cli::cat_rule("Make sure GitHub is set for your website publication")
  url_setting_pages <- paste0(github_url_no_git, "/settings/pages")
  url_actions <- paste0(github_url_no_git, "/actions/workflows/pkgdown.yaml")

  cli::cli_text(
    cli::cli_alert_info(
      "You need to wait for the 'pkgdown' Actions to finish",
      "\nYou know the action is finished if there is a green check box near 'chore: Init Actions and website' on this web page: {.url {url_actions}}."
    )
  )

  if (isTRUE(ask)) {
    sure <- paste0(
      "Say 'yes' when the 'chore: Init Actions and website' action is done and green? (y/n)\n"
    )
    do_it <- readline(sure) == "y"
  } else {
    do_it <- TRUE
  }
  if (isFALSE(do_it)) {
    message("Wait a little more for it to finish or try to guess the problems if it failed...")
  }

  if (isTRUE(ask)) {
    sure <- paste0(
      "You will need to follow a list of operations before you can continue development",
      "\nPlease read them carefully if you want to have access to your documentation website",
      "\nSay 'yes' to continue\n"
    )
    do_it <- readline(sure) == "y"
  }
  if (isTRUE(do_it)) {
    message("You did not write 'yes', but the to-do list will still appear!")
  }

  # usethis::ui_todo(
  # cli::cli_warn(
  cat(
    cli::cli_text("Let's go for the instructions to finish the process:"),
    cli::cli_text("\n1 - Wait for the 'pkgdown' Actions 'chore: Init Actions and website' to finish on: {.url {url_actions}}. This action will create a new branch on GitHub, named 'gh-pages'"),
    cli::cli_text("\n2 - Once the 'gh-pages' branch is created, you need to tell GitHub to follow it."),
    cli::cli_text("Go to: {.url  {url_setting_pages}} and choose 'gh-pages' in the 'Branch' drop-down menu, instead of 'None'. Click 'Save'."),
    cli::cli_text("If the branch is not there, wait a minute and refresh the page."),

    # browseURL(paste0(github_url_no_git, "/settings/pages"))
    cli::cli_text("\n3 - Wait another minute and you'll be able to see your project website at: {.url {url_pages}}"),
    cli::cli_text("Now it's time to continue your project: fill the flat file, inflate, push to GitHub."),
    cli::cli_text("\n> Infos: ", paste(msg, collapse = " \n- ")),
    {
      if (!dir.exists("R")) cli::cli_text("\n> Note: The Action 'R-CMD-check' may fail as you do not have any function in your package yet. Inflate your flat file with a function once, and it should be good.")
    },
    {
      if (!dir.exists("tests")) cli::cli_text("\n> Note: The Action 'test-coverage' may fail as you do not have any test in your package yet. Inflate your flat file with a unit test once, and it should be good.")
    },
    {
      if (isTRUE(ask)) cli::cli_text("\n\nThe next time you run this function, you can set `init_share_on_github(ask = TRUE)`, to not see all the intermediate questions.")
    }
  )

  return(url_pages)
}
