% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fusionPlot.R
\name{fusionPlot}
\alias{fusionPlot}
\title{Create new charts}
\usage{
fusionPlot(data, x, y, type = "column2d", numberSuffix = NULL)
}
\arguments{
\item{data}{Default dataset to use}

\item{x, y}{character name of variable}

\item{type}{type of chart}

\item{numberSuffix}{Specify the suffix for all the Y-axis values on the chart}
}
\description{
Main function to make interactive charts.
Check all charts at \url{https://www.fusioncharts.com/charts}
}
\details{
A 2x2 confusion matrix can be displayed using `type = "confusionMatrix"`.
}
\examples{
library(fusionchartsR)

# Single
df <- data.frame(label = c("Venezuela", "Saudi", "Canada", "Russia"), value = c(290, 260,180, 115))
df \%>\%
fusionPlot(x = "label", y = "value", type = "pie2d") \%>\%
fusionTheme(theme = "fusion")

}
