% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchtools_template.R
\name{batchtools_template}
\alias{batchtools_template}
\alias{batchtools_lsf}
\alias{batchtools_openlava}
\alias{batchtools_sge}
\alias{batchtools_slurm}
\alias{batchtools_torque}
\title{Batchtools futures for LSF, OpenLava, SGE, Slurm, TORQUE etc.}
\usage{
batchtools_lsf(expr, envir = parent.frame(), substitute = TRUE,
  globals = TRUE, label = NULL, template = NULL, resources = list(),
  workers = Inf, ...)

batchtools_openlava(expr, envir = parent.frame(), substitute = TRUE,
  globals = TRUE, label = NULL, template = NULL, resources = list(),
  workers = Inf, ...)

batchtools_sge(expr, envir = parent.frame(), substitute = TRUE,
  globals = TRUE, label = NULL, template = NULL, resources = list(),
  workers = Inf, ...)

batchtools_slurm(expr, envir = parent.frame(), substitute = TRUE,
  globals = TRUE, label = NULL, template = NULL, resources = list(),
  workers = Inf, ...)

batchtools_torque(expr, envir = parent.frame(), substitute = TRUE,
  globals = TRUE, label = NULL, template = NULL, resources = list(),
  workers = Inf, ...)
}
\arguments{
\item{expr}{The R expression to be evaluated}

\item{envir}{The environment in which global environment
should be located.}

\item{substitute}{Controls whether \code{expr} should be
\code{substitute()}:d or not.}

\item{globals}{(optional) a logical, a character vector, a named list, or
a \link[globals]{Globals} object.  If TRUE, globals are identified by code
inspection based on \code{expr} and \code{tweak} searching from environment
\code{envir}.  If FALSE, no globals are used.  If a character vector, then
globals are identified by lookup based their names \code{globals} searching
from environment \code{envir}.  If a named list or a Globals object, the
globals are used as is.}

\item{label}{(optional) Label of the future (where applicable, becomes the
job name for most job schedulers).}

\item{template}{(optional) A batchtools template file or a template string
(in \pkg{brew} format).  If not specified, it is left to the
\pkg{batchtools} package to locate such file using its search rules.}

\item{resources}{A named list passed to the batchtools template (available
as variable \code{resources}).}

\item{workers}{(optional) Additional specification for the batchtools
backend.}

\item{\ldots}{Additional arguments passed to
\code{\link{BatchtoolsFuture}()}.}
}
\value{
An object of class \code{BatchtoolsFuture}.
}
\description{
Batchtools futures for LSF, OpenLava, SGE, Slurm, TORQUE etc. are
asynchronous multiprocess futures that will be evaluated on a compute
cluster via a job scheduler.
}
\details{
These type of batchtools futures rely on batchtools backends set
up using the following \pkg{batchtools} functions:
\itemize{
 \item \code{\link[batchtools]{makeClusterFunctionsLSF}()} for
   \href{https://en.wikipedia.org/wiki/Platform_LSF}{Load Sharing
         Facility (LSF)}
 \item \code{makeClusterFunctionsOpenLava()} for
   \href{https://en.wikipedia.org/wiki/OpenLava}{OpenLava}
 \item \code{\link[batchtools]{makeClusterFunctionsSGE}()} for
   \href{https://en.wikipedia.org/wiki/Oracle_Grid_Engine}{Sun/Oracle
         Grid Engine (SGE)}
 \item \code{\link[batchtools]{makeClusterFunctionsSlurm}()} for
   \href{https://en.wikipedia.org/wiki/Slurm_Workload_Manager}{Slurm}
 \item \code{\link[batchtools]{makeClusterFunctionsTORQUE}()} for
   \href{https://en.wikipedia.org/wiki/TORQUE}{TORQUE} / PBS
}
}
