% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{pid_exists}
\alias{pid_exists}
\title{Check whether a process PID exists or not}
\usage{
pid_exists(pid, debug = getOption("future.debug", FALSE))
}
\arguments{
\item{pid}{A positive integer.}
}
\value{
Returns \code{TRUE} if a process with the given PID exists,
\code{FALSE} if a process with the given PID does not exists, and
\code{NA} if it is not possible to check PIDs on the current system.
}
\description{
Check whether a process PID exists or not
}
\details{
There is no single go-to function in \R for testing whether a PID exists
or not.  Instead, this function tries to identify a working one among
multiple possible alternatives.  A method is considered working if the
PID of the current process is successfully identified as being existing
such that \code{pid_exists(Sys.getpid())} is \code{TRUE}.  If no working
approach is found, \code{pid_exists()} will always return \code{NA}
regardless of PID tested.
On Unix, including macOS, alternatives \code{tools::pskill(pid, signal = 0L)}
and \code{system2("ps", args = pid)} are used.
On Windows, various alternatives of \code{system2("tasklist", ...)} are used.
}
\references{
\enumerate{
\item The Open Group Base Specifications Issue 7, 2018 edition,
IEEE Std 1003.1-2017 (Revision of IEEE Std 1003.1-2008)
\url{http://pubs.opengroup.org/onlinepubs/9699919799/functions/kill.html}
\item Microsoft, tasklist, 2018-08-30,
\url{https://docs.microsoft.com/en-us/windows-server/administration/windows-commands/tasklist}
\item R-devel thread 'Detecting whether a process exists or not by its PID?',
2018-08-30.
\url{https://stat.ethz.ch/pipermail/r-devel/2018-August/076702.html}
}
}
\seealso{
\code{\link[tools]{pskill}()} and \code{\link[base]{system2}()}.
}
\keyword{internal}
