% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzify.R
\name{fuzzify}
\alias{fuzzify}
\title{Convert Real Value Numbers to Triangular Fuzzy Numbers}
\usage{
fuzzify(x, y = NULL, method = "mean", err = 0, dimnames = list("x",
  "y"), ...)
}
\arguments{
\item{x}{numeric vector.}

\item{y}{vector that can be coerced to factor (optional).}

\item{method}{character vector specifying the conversion method. See Details.}

\item{err}{numeric vector. Error term for the error method.}

\item{dimnames}{\code{list} of length 2 giving names of the \code{x} and \code{y} 
variables.}

\item{...}{additional parameters passed to other functions.}
}
\value{
A data.frame with columns representing the central value, left and right spread of
 \code{x} and the values in \code{y} coerrced to a factor. Attempt is made to inherit 
 names from the input data. Methods 
 \code{mean} and \code{zero} will return symmetric TFNs, whereas methods \code{median} and 
 \code{error} can return non-symmetric TFNs depending on input data and the data or the
 values in the \code{err} argument.
}
\description{
Uses naive alternative methods to approximate triangular fuzzy
numbers from real value number input data.
}
\details{
Converts crisp numbers in \code{x} to a triangular fuzzy number (TFN). Optionally, 
 values in \code{y} can be used as grouping elements and are coerced to a factor.
 
 Method \code{mean} calculates the central value of a TFN as the mean of \code{x} given
 \code{y}, and the left and right spreads as standard deviations. 
 
 Method \code{median} gives the central values as a median and left and right spreads 
 are calculated as distance of the first and third quartile from the median.
 
 Method \code{zero} inserts zeros to both spreads.
 
 Method \code{error} uses a user-defined numeric value or vector for the spreads. 
 The length of the numeric vector in argument \code{err} must be in 
 (1, \code{length(x)}, 2 * \code{length(x)}).
}
\examples{
fuzzify(1:5)
fuzzify(1:6, c(1,1,1,2,2,2), method = "err", err = runif(6) * 1e-3)
}
