% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bats}
\alias{bats}
\title{Temperature Data of Hibernating Bats and Climate at Site}
\format{
A data frame with 528 rows and two variables:
\describe{
\item{\code{MAST}}{numeric Mean annual surface temperature at the site in degrees
Celsius}
\item{\code{temperature}}{numeric Body surface temperature of hibernating bats in
degrees Celsius}
}
}
\source{
Martinkova, N., Pikula, J., Zukal, J., Kovacova, V., Bandouchova, H.,
Bartonicka, T., Botvinkin, A.D., Brichta, J., Dundarova, H., Kokurewicz, T.,
Irwin, N.R., Linhart, P., Orlov, O.L., Piacek, V., Skrabanek, P., Tiunov,
M.P. and Zahradnikova, A., Jr. (2018) Hibernation temperature-dependent
\emph{Pseudogymnoascus destructans} infection intensity in Palearctic bats.
\emph{Virulence} 9: 1734-1750.

Hijmans, R.J., Cameron, S.E., Parra, J.L., Jones, P.G. and Jarvis, A. (2005) Very
high resolution interpolated climate surfaces for global land areas.
\emph{International Journal of Climatology} 25: 1965-1978.
}
\usage{
data(bats)
}
\description{
Body surface temperature of multiple species of hibernating bats and mean annual
surface temperature at the hibernation site.
}
\examples{
data(bats)
# remove outlier
dat <- bats[!(bats$MAST < 0 & bats$temperature > 7), ]
# fuzzy linear regression model as published
fit <- fuzzylm(temperature ~ MAST, data = dat, method = "plrls", h = 0.01, k1 = 5)
plot(fit, res = 30, col = "orange")
}
\keyword{datasets}
