% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_aggregate.R
\name{boot_aggregate}
\alias{boot_aggregate}
\title{Simple tool that aggregates the value of CATT coefficients in
staggered difference-in-difference setups with inference based on
a wild cluster bootstrap (see details) - similar to \code{fixest::aggregate()}}
\usage{
boot_aggregate(
  x,
  agg,
  full = FALSE,
  use_weights = TRUE,
  clustid = NULL,
  B,
  bootcluster = "max",
  fe = NULL,
  sign_level = 0.05,
  seed = NULL,
  beta0 = NULL,
  type = "rademacher",
  impose_null = TRUE,
  bootstrap_type = "fnw11",
  p_val_type = "two-tailed",
  nthreads = getBoottest_nthreads(),
  tol = 1e-06,
  maxiter = 10,
  ssc = boot_ssc(adj = TRUE, fixef.K = "none", cluster.adj = TRUE, cluster.df =
    "conventional"),
  engine = getBoottest_engine(),
  floattype = "Float64",
  maxmatsize = FALSE,
  bootstrapc = FALSE,
  getauxweights = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of type fixest estimated using \code{sunab()}}

\item{agg}{A character scalar describing the variable names to be
aggregated, it is pattern-based. All variables that match the pattern
will be aggregated. It must be of the form \code{"(root)"}, the parentheses
must be there and the resulting variable name will be \code{"root"}. You
can add another root with parentheses: \code{"(root1)regex(root2)"}, in
which case the resulting name is \code{"root1::root2"}. To name the resulting
variable differently you can pass a named vector: \code{c("name" = "pattern")}
or \code{c("name" = "pattern(root2)")}. It's a bit intricate sorry, please
see the examples.}

\item{full}{Logical scalar, defaults to \code{FALSE}. If \code{TRUE}, then all
coefficients are returned, not only the aggregated coefficients.}

\item{use_weights}{Logical, default is \code{TRUE}. If the estimation was
weighted, whether the aggregation should take into account the weights.
Basically if the weights reflected frequency it should be \code{TRUE}.}

\item{clustid}{A character vector or rhs formula containing the names of the
cluster variables. If NULL,
a heteroskedasticity-robust (HC1) wild bootstrap is run.}

\item{B}{Integer. The number of bootstrap iterations. When the number of
clusters is low,
increasing B adds little additional runtime.}

\item{bootcluster}{A character vector or rhs formula of length 1. Specifies
the bootstrap clustering variable or variables. If more
than one variable is specified, then bootstrapping is clustered by the
intersections of
clustering implied by the listed variables. To mimic the behavior of
stata's boottest command,
the default is to cluster by the intersection of all the variables
specified via the \code{clustid} argument,
even though that is not necessarily recommended (see the paper by
Roodman et al cited below, section 4.2).
Other options include "min", where bootstrapping is clustered by
the cluster variable with the fewest clusters.
Further, the subcluster bootstrap (MacKinnon & Webb, 2018) is
supported - see the \code{vignette("fwildclusterboot", package = "fwildclusterboot")} for details.}

\item{fe}{A character vector or rhs formula of length one which contains
the name of the fixed effect to be projected
out in the bootstrap. Note: if regression weights are used, fe
needs to be NULL.}

\item{sign_level}{A numeric between 0 and 1 which sets the significance level
of the inference procedure. E.g. sign_level = 0.05
returns 0.95\% confidence intervals. By default, sign_level = 0.05.}

\item{seed}{An integer. Allows to set a random seed. For details, see below.}

\item{beta0}{Deprecated function argument. Replaced by function argument 'r'.}

\item{type}{character or function. The character string specifies the type
of boostrap to use: One of "rademacher", "mammen", "norm"
and "webb". Alternatively, type can be a function(n) for drawing
wild bootstrap factors. "rademacher" by default.
For the Rademacher distribution, if the number of replications B
exceeds
the number of possible draw ombinations, 2^(#number of clusters),
then \code{boottest()}
will use each possible combination once (enumeration).}

\item{impose_null}{Logical. Controls if the null hypothesis is imposed on
the bootstrap dgp or not. Null imposed \code{(WCR)} by default.
If FALSE, the null is not imposed \code{(WCU)}}

\item{bootstrap_type}{Determines which wild cluster bootstrap type should be
run. Options are "fnw11", which runs a "11" type
wild cluster bootstrap via the algorithm outlined in "fast and wild"
(Roodman et al (2019)).}

\item{p_val_type}{Character vector of length 1. Type of p-value.
By default "two-tailed". Other options include "equal-tailed",
">" and "<".}

\item{nthreads}{The number of threads. Can be: a) an integer lower than,
or equal to, the maximum number of threads; b) 0: meaning
all available threads will be used; c) a number strictly
between 0 and 1 which represents the fraction of all threads
to use. The default is to use 1 core.}

\item{tol}{Numeric vector of length 1. The desired accuracy
(convergence tolerance) used in the root finding procedure to find
the confidence interval.
1e-6 by default.}

\item{maxiter}{Integer. Maximum number of iterations used in the root
finding procedure to find the confidence interval.
10 by default.}

\item{ssc}{An object of class \code{boot_ssc.type} obtained with the function
\code{\link[=boot_ssc]{boot_ssc()}}. Represents how the small sample
adjustments are computed. The defaults are \verb{adj = TRUE, fixef.K = "none", cluster.adj = "TRUE", cluster.df = "conventional"}.
You can find more details in the help file for \code{boot_ssc()}.
The function is purposefully designed to mimic fixest's
\code{\link[fixest:ssc]{fixest::ssc()}} function.}

\item{engine}{Character scalar. Either "R", "R-lean" or "WildBootTests.jl".
Controls if \code{boottest()} should run via its native R implementation
or \code{WildBootTests.jl}.
"R" is the default and implements the cluster bootstrap
as in Roodman (2019). "WildBootTests.jl" executes the
wild cluster bootstrap via the WildBootTests.jl
package. For it to run, Julia and WildBootTests.jl need
to be installed.
The "R-lean" algorithm is a memory friendly, but less
performant rcpp-armadillo based implementation of the wild
cluster bootstrap.
Note that if no cluster is provided, boottest() always
defaults to the "lean" algorithm. You can set the employed
algorithm globally by using the
\code{setBoottest_engine()} function.}

\item{floattype}{Float64 by default. Other option: Float32. Should floating
point numbers in Julia be represented as 32 or 64 bit? Only relevant when
'engine = "WildBootTests.jl"'}

\item{maxmatsize}{NULL by default = no limit. Else numeric scalar to set
the maximum size of auxilliary weight matrix (v), in gigabytes. Only
relevant when 'engine = "WildBootTests.jl"'}

\item{bootstrapc}{Logical scalar, FALSE by default. TRUE  to request
bootstrap-c instead of bootstrap-t. Only relevant when
'engine = "WildBootTests.jl"'}

\item{getauxweights}{Logical. Whether to save auxilliary weight matrix (v)}

\item{...}{misc function arguments}
}
\value{
A data frame with aggregated coefficients, p-values and
confidence intervals.
}
\description{
This is a function helping to replicate the estimator from Sun and
Abraham (2021, Journal of Econometrics). You first need to perform
an estimation with cohort and relative periods dummies
(typically using the function i), this leads to estimators of the
cohort average treatment effect on the treated (CATT). Then you can
use this function to retrieve the average treatment effect on each
relative period,or for any other way you wish to aggregate the CATT.
}
\details{
Note that contrary to the SA article, here the cohort share
in the sample is considered to be a perfect measure for the
cohort share in the population.

Most of this function is written by Laurent Bergé and used
in the fixest package published under GPL-3,
https://cran.r-project.org/web/packages/fixest/index.html
minor changes by Alexander Fischer
}
\examples{

\dontrun{
if(requireNamespace("fixest")){
library(fixest)
data(base_stagg)
# The DiD estimation
res_sunab = feols(y ~ x1 + sunab(year_treated, year) | id + year, base_stagg)
res_sunab_3ref = feols(y ~ x1 + sunab(
 year_treated, year, ref.p = c(.F + 0:2, -1)) |
                        id + year, 
                      cluster = "id",
                      base_stagg, 
                      ssc = ssc(adj = FALSE, cluster.adj = FALSE))

aggregate(res_sunab, agg = "ATT")
# test ATT equivalence
boot_att <- 
 boot_aggregate(
   res_sunab, 
   B = 9999, 
   agg = "ATT", 
   clustid = "id" 
 )
head(boot_att)

#'boot_agg2 <- 
 boot_aggregate(
   res_sunab, 
   B = 99999, 
   agg = TRUE,
   ssc = boot_ssc(adj = FALSE, cluster.adj = FALSE)
 )

}
}
}
