/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui;

import java.io.PrintStream;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.logging.ApplicationLog;
import org.af.commons.logging.LoggingSystem;
import org.af.jhlir.backends.rengine.RCallServicesREngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.gui.DebugTextConsole;
import org.mutoss.gui.ErrorDialogSGTK;
import org.mutoss.gui.LoggingOutputStream;
import org.rosuda.JRI.RMainLoopCallbacks;
import org.rosuda.JRI.Rengine;
import org.rosuda.REngine.JRI.JRIEngine;
import org.rosuda.REngine.REngine;
import org.rosuda.REngine.REngineException;

public class RControl {
    private static final Log logger = LogFactory.getLog(RControl.class);
    protected static RControl rc = null;
    protected static RCallServicesREngine rcs = null;
    public static DebugTextConsole console = null;

    public static RControl getRControl(boolean debug) {
        if (rc == null) {
            rc = new RControl(debug);
        }
        return rc;
    }

    public static RCallServicesREngine getR() {
        RControl.getRControl(true);
        return rcs;
    }

    protected RControl(boolean debug) {
        Rengine rengine;
        if (!LoggingSystem.alreadyInitiated()) {
            LoggingSystem.init((String)"/org/mutoss/gui/commons-logging.properties", (System.getProperty("eclipse") == null && !debug ? 1 : 0) != 0, (System.getProperty("eclipse") != null || debug ? 1 : 0) != 0, (ApplicationLog)new ApplicationLog());
            ErrorHandler.init((String)"rohmeyer@small-projects.de", (String)"http://www.algorithm-forge.com/report/bugreport.php", (boolean)true, (boolean)true, ErrorDialogSGTK.class);
        }
        if ((rengine = Rengine.getMainEngine()) == null) {
            if (System.getProperty("eclipse") != null) {
                console = new DebugTextConsole();
                rengine = new Rengine(new String[]{"--vanilla"}, true, (RMainLoopCallbacks)console);
            } else {
                rengine = new Rengine();
            }
        }
        try {
            rcs = new RCallServicesREngine((REngine)new JRIEngine(rengine));
            if (System.getProperty("eclipse") != null) {
                rcs.eval("require(gMCP)");
            }
        }
        catch (REngineException e) {
            ErrorHandler.getInstance().makeErrDialog("Error creating RCallServicesREngine!", (Object)e);
        }
        if (System.getProperty("eclipse") == null && !debug) {
            System.setOut(new PrintStream(new LoggingOutputStream(logger), true));
        }
    }

    public static String getFraction(Double d) {
        return RControl.getR().eval("as.character(fractions(" + d + "))").asRChar().getData()[0];
    }
}

