/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.dialogs;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.af.commons.io.FileTools;

public class TextFileViewer
extends JDialog
implements ActionListener {
    JTextArea jta;

    public TextFileViewer(JFrame p, File file) {
        super((Frame)p, file.getName());
        String news;
        try {
            news = FileTools.readFileAsString((File)file);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(p, "File \"" + file.getAbsolutePath() + "\" not found!", "File not found", 0);
            this.dispose();
            return;
        }
        this.setUp(news);
    }

    public TextFileViewer(JFrame p, String title, String text) {
        super((Frame)p, title);
        this.setUp(text);
    }

    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }

    private void setUp(String text) {
        this.jta = new JTextArea(text);
        this.jta.setFont(new Font("Monospaced", 0, 12));
        this.jta.setLineWrap(true);
        this.jta.setWrapStyleWord(true);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 5;
        c.ipady = 5;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.getContentPane().setLayout(new GridBagLayout());
        JScrollPane jsp = new JScrollPane(this.jta);
        this.getContentPane().add((Component)jsp, c);
        ++c.gridy;
        this.pack();
        this.setSize(800, 600);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }
}

