/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.datatable;

import java.util.List;
import java.util.Vector;
import org.af.gMCP.gui.graph.EdgeWeight;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RDataFrameRef {
    private static final Log logger = LogFactory.getLog(RDataFrameRef.class);
    List<String> rcNames = new Vector<String>();
    Vector<Vector<EdgeWeight>> data = new Vector();

    public String getColName(int col) {
        return this.rcNames.get(col);
    }

    public String getRowName(int row) {
        return this.rcNames.get(row);
    }

    public void setValue(int row, int col, EdgeWeight value) {
        this.data.get(row).set(col, value);
    }

    public EdgeWeight getElement(int row, int col) {
        return this.data.get(row).get(col);
    }

    public void delRowCol(int col) {
        this.rcNames.remove(col);
        this.data.remove(col);
        for (Vector<EdgeWeight> v : this.data) {
            v.remove(col);
        }
    }

    public int getRowCount() {
        return this.data.size();
    }

    public int getColumnCount() {
        return this.data.size();
    }

    public void addRowCol(String name) {
        int i;
        this.rcNames.add(name);
        Vector<EdgeWeight> row = new Vector<EdgeWeight>();
        for (i = 0; i < this.getColumnCount(); ++i) {
            row.add(new EdgeWeight(0.0));
        }
        this.data.add(row);
        for (i = 0; i < this.getRowCount(); ++i) {
            this.data.get(i).add(new EdgeWeight(0.0));
        }
    }

    public String getRMatrix() {
        String m = "matrix(c(";
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                m = m + this.data.get(i).get(j) + (i == this.getRowCount() - 1 && j == this.getColumnCount() - 1 ? "" : ",");
            }
        }
        m = m + "), nrow=" + this.getRowCount() + ")";
        return m;
    }

    public void removeAll() {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            this.delRowCol(i);
        }
    }
}

