/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.io.FileTransfer;
import org.af.commons.logging.LoggingSystem;
import org.af.commons.logging.widgets.DetailsDialog;
import org.af.commons.tools.OSTools;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.AboutDialog;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.ReproducableLog;
import org.af.gMCP.gui.dialogs.GraphSendToArchiveDialog;
import org.af.gMCP.gui.dialogs.ParameterDialog;
import org.af.gMCP.gui.dialogs.PowerDialogParameterUncertainty;
import org.af.gMCP.gui.dialogs.RObjectLoadingDialog;
import org.af.gMCP.gui.dialogs.RearrangeNodesDialog;
import org.af.gMCP.gui.dialogs.TextFileViewer;
import org.af.gMCP.gui.dialogs.VariableNameDialog;
import org.af.gMCP.gui.graph.GraphView;
import org.af.gMCP.gui.options.OptionsDialog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingworker.SwingWorker;

public class MenuBarMGraph
extends JMenuBar
implements ActionListener {
    GraphView control;
    private static final Log logger = LogFactory.getLog(MenuBarMGraph.class);
    JMenu fmenu = new JMenu("File");
    JMenu extraMenu = new JMenu("Extras");
    JMenu exampleMenu = new JMenu("Example graphs");
    String[] pdfViewers = new String[]{"evince", "xpdf"};
    String correlation;
    File f;
    public String LATEX_BEGIN_DOCUMENT = "\\documentclass[11pt]{article}\n\\usepackage{tikz}\n\\usetikzlibrary{decorations,arrows,shapes}\n\\begin{document}\n";
    public String LATEX_END_DOCUMENT = "\\end{document}";

    public MenuBarMGraph(GraphView control) {
        this.control = control;
        this.fmenu.add(this.makeMenuItem("New Graph", "new graph", 78));
        this.fmenu.add(this.makeMenuItem("Load Graph from R", "load graph from R", 76));
        this.fmenu.add(this.makeMenuItem("Load Graph from RData file", "load graph"));
        this.fmenu.addSeparator();
        this.fmenu.add(this.makeMenuItem("Load p-Values from R", "load p-values from R"));
        this.fmenu.addSeparator();
        this.fmenu.add(this.makeMenuItem("Save Graph to R", "save graph to R", 83));
        this.fmenu.add(this.makeMenuItem("Save Graph to RData file", "save graph"));
        this.fmenu.addSeparator();
        this.fmenu.add(this.makeMenuItem("Export Graph to PNG Image", "export graph image", 80));
        this.fmenu.add(this.makeMenuItem("Export Graph to LaTeX File", "export graph latex", 65));
        this.fmenu.add(this.makeMenuItem("Copy Graph to Clip Board", "copy graph to clipboard"));
        this.fmenu.add(this.makeMenuItem("Show LaTeX Code for Graph", "show graph latex", 67));
        this.fmenu.addSeparator();
        this.fmenu.add(this.makeMenuItem("Save LaTeX Report", "save latex report", 82));
        JMenuItem item = this.makeMenuItem("Save PDF Report", "save pdf");
        item.setEnabled(false);
        this.fmenu.add(item);
        this.fmenu.addSeparator();
        this.createLastUsed();
        this.fmenu.setMnemonic(70);
        this.add(this.fmenu);
        this.createExampleMenu();
        this.add(this.exampleMenu);
        this.exampleMenu.setMnemonic(88);
        JMenu menu = new JMenu("Analysis");
        menu.setMnemonic(65);
        menu.add(this.makeMenuItem("Graph analysis", "graphAnalysis"));
        menu.addSeparator();
        menu.add(this.makeMenuItem("Power analysis (still experimental)", "powerAnalysis"));
        this.add(menu);
        this.createExtraMenu();
        this.add(this.extraMenu);
        menu = new JMenu("Help");
        menu.setMnemonic(72);
        menu.add(this.makeMenuItem("About", "showAbout", 66));
        menu.add(this.makeMenuItem("Introduction to gMCP", "showAppHelp", 73));
        menu.add(this.makeMenuItem("Weighted parametric tests defined by graphs", "showParametric", 80));
        menu.add(this.makeMenuItem("gMCP R Online Reference manual", "showManual", 77));
        menu.add(this.makeMenuItem("Paper about gMCP in the Biometrical Journal", "showPaper1", 80));
        menu.add(this.makeMenuItem("References", "showReferences", 82));
        menu.addSeparator();
        menu.add(this.makeMenuItem("Version Info / NEWS", "showNEWS", 78));
        this.add(menu);
    }

    public void createExampleMenu() {
        this.exampleMenu.removeAll();
        JMenu subMenu = new JMenu("Common test procedures for any number of hypotheses");
        subMenu.add(this.makeMenuItem("Bonferroni-Holm procedure", "bht"));
        subMenu.add(this.makeMenuItem("Fixed sequence test", "fixedSequence"));
        subMenu.add(this.makeMenuItem("Fallback procedure", "fallback"));
        this.exampleMenu.add(subMenu);
        subMenu = new JMenu("3 unstructured hypotheses");
        subMenu.add(this.makeMenuItem("Improved fallback procedure I", "fallbackI"));
        subMenu.add(this.makeMenuItem("Improved fallback procedure II", "fallbackII"));
        this.exampleMenu.add(subMenu);
        subMenu = new JMenu("2 primary & 2 secondary hypotheses");
        subMenu.add(this.makeMenuItem("Parallel Gatekeeping with 4 Hypotheses", "pg"));
        subMenu.add(this.makeMenuItem("Improved Parallel Gatekeeping with 4 Hypotheses", "pgi"));
        subMenu.addSeparator();
        subMenu.add(this.makeMenuItem("Truncated Holm procedure", "truncHolm"));
        subMenu.addSeparator();
        subMenu.add(this.makeMenuItem("General successive graph", "gSuccessive"));
        subMenu.add(this.makeMenuItem("   Simple successive graph I from Maurer et al. (2011)", "successiveI"));
        subMenu.add(this.makeMenuItem("   Simple successive graph II from Maurer et al. (2011)", "successiveII"));
        subMenu.addSeparator();
        subMenu.add(this.makeMenuItem("Graph from Hung and Wang (2010)", "hung"));
        subMenu.add(this.makeMenuItem("Graph from Huque, Alosh and Bhore (2011)", "huque"));
        this.exampleMenu.add(subMenu);
        subMenu = new JMenu("3 primary & 3 secondary hypotheses");
        subMenu.add(this.makeMenuItem("Graph from Bauer et al. (2001)", "bauer"));
        subMenu.add(this.makeMenuItem("Graph from Bretz et al. (2011)", "bretzEtAl"));
        this.exampleMenu.add(subMenu);
        subMenu = new JMenu("2 primary & 2 secondary & 2 tertiary hypotheses");
        subMenu.add(this.makeMenuItem("Graph from Bretz et al. (2009), Figure 14a", "bretzEtAl2009a"));
        subMenu.add(this.makeMenuItem("Graph from Bretz et al. (2009), Figure 14b", "bretzEtAl2009b"));
        subMenu.add(this.makeMenuItem("Graph from Bretz et al. (2009), Figure 15", "bretzEtAl2009c"));
        this.exampleMenu.add(subMenu);
        subMenu = new JMenu("Miscellaneous");
        subMenu.add(this.makeMenuItem("Graph from Hommel et al. (2007)", "hommelEtAl"));
        subMenu.add(this.makeMenuItem("Graph from Hommel et al. (2007) simplified", "hommelEtAlSimple"));
        subMenu.add(this.makeMenuItem("Drug clinical trial example (serial gatekeeping) from Maurer et al. (1995)", "maurer1995"));
        subMenu.add(this.makeMenuItem("Graph I from Ferber et al. (2011)", "ferber2011"));
        subMenu.add(this.makeMenuItem("Graph II from Ferber et al. (2011)", "ferber2011b"));
        this.exampleMenu.add(subMenu);
        if (Configuration.getInstance().getGeneralConfig().experimentalFeatures()) {
            subMenu = new JMenu("Entangled graphs");
            subMenu.add(this.makeMenuItem("Entangled Graph I from Maurer et al. (2012)", "entangled1"));
            subMenu.add(this.makeMenuItem("Entangled Graph II from Maurer et al. (2012)", "entangled2"));
            this.exampleMenu.add(subMenu);
        }
        this.exampleMenu.add(this.makeMenuItem("Browse archive of user submitted graphs", "userSubmitted"));
    }

    public void createExtraMenu() {
        this.extraMenu.removeAll();
        this.extraMenu.add(this.makeMenuItem("Options", "showOptions", 79));
        this.extraMenu.add(this.makeMenuItem("Set all options back to default", "clearOptions", 67));
        this.extraMenu.addSeparator();
        this.extraMenu.add(this.makeMenuItem("Change Layout of graph", "changeGraphLayout", 71));
        this.extraMenu.add(this.makeMenuItem("Set variables to specific real values", "replaceVariables", 86));
        this.extraMenu.addSeparator();
        this.extraMenu.add(this.makeMenuItem("Log", "showLog", 76));
        this.extraMenu.add(this.makeMenuItem("Report error", "reportError", 82));
        this.extraMenu.add(this.makeMenuItem("Submit your own graph to gMCP archive", "submitGraph"));
        if (System.getProperty("eclipse") != null) {
            this.extraMenu.add(this.makeMenuItem("Debug console", "debugConsole", 68));
        }
        this.extraMenu.setMnemonic(69);
        if (Configuration.getInstance().getGeneralConfig().experimentalFeatures()) {
            this.extraMenu.addSeparator();
            this.extraMenu.add(this.makeMenuItem("Add entangled graph", "entangledGraphs"));
        }
    }

    private void createLastUsed() {
        int i;
        List<String> graphs = Configuration.getInstance().getGeneralConfig().getLatestGraphs();
        for (i = this.fmenu.getItemCount() - 1; i > 16; --i) {
            this.fmenu.remove(i);
        }
        if (graphs.size() > 0) {
            i = 0;
            for (String graph : graphs) {
                ++i;
                String s = graph;
                logger.info((Object)("Process last used graph: '" + s + "'."));
                File f = new File(s);
                if (f.exists()) {
                    String path = f.getParent();
                    if (path.length() > 20) {
                        path = path.substring(0, 17) + "...";
                    }
                    s = f.getName() + " [" + path + "]";
                    this.fmenu.add(this.makeMenuItem(i + " " + s, "LOAD_GRAPH" + graph, (i + "").charAt(0)));
                    continue;
                }
                if (!s.startsWith("R Object: ")) continue;
                s = s.substring(10);
                if (!RControl.getR().eval("exists(\"" + s + "\")").asRLogical().getData()[0]) continue;
                this.fmenu.add(this.makeMenuItem(i + " " + s, "LOAD_GRAPH" + graph, (i + "").charAt(0)));
            }
            this.fmenu.addSeparator();
        }
        this.fmenu.add(this.makeMenuItem("Exit", "exit", 88));
    }

    private JMenuItem makeMenuItem(String text, String action, int key) {
        JMenuItem item = this.makeMenuItem(text, action);
        item.setMnemonic(key);
        return item;
    }

    private JMenuItem makeMenuItem(String text, String action, char key) {
        JMenuItem item = this.makeMenuItem(text, action);
        item.setMnemonic(key);
        return item;
    }

    public void loadGraph(String string) {
        this.control.stopTesting();
        this.control.getNL().loadGraph(string);
        this.control.setGraphName(RControl.getR().eval("gMCP:::nextAvailableName(gMCP:::removeSymbols(\"" + string + "\", numbers=FALSE))").asRChar().getData()[0]);
        this.control.getMainFrame().validate();
    }

    public void newGraph() {
        this.control.stopTesting();
        this.control.getNL().reset();
    }

    public void showAbout() {
        new AboutDialog(this.control.getMainFrame());
    }

    public void showLog() {
        new DetailsDialog(LoggingSystem.getInstance().makeDetailsPanel());
    }

    public void reportError() {
        ErrorHandler.getInstance().makeErrDialog("Report Error");
    }

    public void actionPerformed(ActionEvent e) {
        ReproducableLog.logGUI("Menu entry \"" + e.getActionCommand() + "\"");
        if (e.getActionCommand().startsWith("LOAD_GRAPH")) {
            String s = e.getActionCommand().substring(10);
            logger.info((Object)("Trying to load \"" + s + "\""));
            if (s.startsWith("R Object")) {
                s = s.substring(10);
                this.loadGraph(s);
                Configuration.getInstance().getGeneralConfig().addGraph("R Object: " + s);
                this.createLastUsed();
            } else {
                File f = new File(s);
                if (!f.exists()) {
                    JOptionPane.showMessageDialog(this.control.getMainFrame(), "Could not find file:\n" + s, "Could not find file", 0);
                    return;
                }
                if (s.toLowerCase().endsWith(".rdata")) {
                    this.loadGraph(f);
                }
            }
        } else if (e.getActionCommand().equals("new graph")) {
            this.newGraph();
        } else if (e.getActionCommand().equals("save graph")) {
            if (this.control.getNL().getNodes().size() == 0) {
                JOptionPane.showMessageDialog(this.control.getMainFrame(), "Will not save empty graph.", "Saving to R failed.", 0);
                return;
            }
            this.control.saveGraph();
            this.createLastUsed();
            this.control.isGraphSaved = true;
        } else if (e.getActionCommand().equals("save graph to R")) {
            if (this.control.getNL().getNodes().size() == 0) {
                JOptionPane.showMessageDialog(this.control.getMainFrame(), "Will not save empty graph.", "Saving to R failed.", 0);
                return;
            }
            VariableNameDialog vnd = new VariableNameDialog(this.control.getGraphGUI(), this.control.getGraphName());
            String name = this.control.getNL().saveGraph(vnd.getName(), true);
            Configuration.getInstance().getGeneralConfig().addGraph("R Object: " + name);
            this.createLastUsed();
            this.control.isGraphSaved = true;
        } else if (e.getActionCommand().equals("copy graph to clipboard")) {
            this.control.copyGraphToClipboard();
        } else if (e.getActionCommand().equals("export graph image")) {
            this.saveGraphImage();
        } else if (e.getActionCommand().equals("export graph latex")) {
            this.exportLaTeXGraph();
        } else if (e.getActionCommand().equals("show graph latex")) {
            this.showLaTeXGraph();
        } else if (e.getActionCommand().equals("save pdf")) {
            this.notYetSupported();
        } else if (e.getActionCommand().equals("save latex report")) {
            this.exportLaTeXReport();
        } else if (e.getActionCommand().equals("load graph")) {
            this.loadGraph();
        } else if (e.getActionCommand().equals("load graph from R")) {
            new RObjectLoadingDialog(this.control.getGraphGUI());
            this.createLastUsed();
        } else if (e.getActionCommand().equals("showLog")) {
            this.showLog();
        } else if (e.getActionCommand().equals("reportError")) {
            this.reportError();
        } else if (e.getActionCommand().equals("exit")) {
            this.control.getMainFrame().windowClosing(null);
        } else if (e.getActionCommand().equals("showAppHelp")) {
            this.showFile("doc/gMCP.pdf");
        } else if (e.getActionCommand().equals("showParametric")) {
            this.showFile("doc/parametric.pdf");
        } else if (e.getActionCommand().equals("showManual")) {
            this.showURL("http://cran.at.r-project.org/web/packages/gMCP/gMCP.pdf");
        } else if (e.getActionCommand().equals("showPaper1")) {
            this.showURL("http://onlinelibrary.wiley.com/doi/10.1002/bimj.201000239/full");
        } else if (e.getActionCommand().equals("showReferences")) {
            this.showFile("References.html");
        } else if (e.getActionCommand().equals("showEpsDoc")) {
            this.showFile("doc/EpsilonEdges.pdf");
        } else if (e.getActionCommand().equals("showNEWS")) {
            new TextFileViewer(this.control.getMainFrame(), new File(RControl.getR().eval("system.file(\"NEWS\", package=\"gMCP\")").asRChar().getData()[0]));
        } else if (e.getActionCommand().equals("showAbout")) {
            new AboutDialog(this.control.getMainFrame());
        } else if (e.getActionCommand().equals("showOptions")) {
            new OptionsDialog(this.control.getMainFrame());
        } else if (e.getActionCommand().equals("clearOptions")) {
            Configuration.getInstance().clearConfiguration();
            this.control.getMainFrame().repaint();
        } else if (e.getActionCommand().equals("debugConsole")) {
            RControl.console.setVisible(true);
        } else if (e.getActionCommand().equals("submitGraph")) {
            if (this.control.getNL().getNodes().size() == 0) {
                JOptionPane.showMessageDialog(this.control.getMainFrame(), "Will not submit empty graph.", "Empty graph", 0);
                return;
            }
            this.submitGraph();
        } else if (e.getActionCommand().equals("userSubmitted")) {
            JOptionPane.showMessageDialog(this.control.getMainFrame(), "This is a brand new feature and there are no user submitted graphs yet.\nBe the first to submit a graph:\n You find the option to do so in the \"Extras\" menu.", "No graphs available.", 1);
        } else if (e.getActionCommand().equals("graphAnalysis")) {
            if (this.control.getNL().getNodes().size() == 0) {
                JOptionPane.showMessageDialog(this.control.getMainFrame(), "Graph is empty!", "Graph is empty!", 0);
                return;
            }
            this.control.getNL().saveGraph(".tmpGraph", false);
            String text = RControl.getR().eval("graphAnalysis(.tmpGraph, file=tempfile())").asRChar().getData()[0];
            new TextFileViewer(this.control.getMainFrame(), "Graph analysis", text);
        } else if (e.getActionCommand().equals("powerAnalysis")) {
            if (this.control.getNL().getNodes().size() == 0) {
                JOptionPane.showMessageDialog(this.control.getMainFrame(), "Graph is empty!", "Graph is empty!", 0);
                return;
            }
            if (this.control.getMainFrame().getPView().jrbSimes.isSelected()) {
                JOptionPane.showMessageDialog(this.control.getMainFrame(), "Simes test not yet supported in power calculations.", "Simes test not yet supported", 0);
                return;
            }
            new PowerDialogParameterUncertainty(this.control.getMainFrame());
        } else if (e.getActionCommand().equals("load p-values from R")) {
            this.control.loadPValuesFromR();
        } else if (e.getActionCommand().equals("changeGraphLayout")) {
            if (this.control.getNL().getNodes().size() == 0) {
                JOptionPane.showMessageDialog(this.control.getMainFrame(), "Graph is empty.", "Empty graph", 0);
                return;
            }
            new RearrangeNodesDialog(this.control.getMainFrame());
        } else if (e.getActionCommand().equals("replaceVariables")) {
            Set<String> variables = this.control.getNL().getAllVariables();
            if (variables.isEmpty() || variables.size() == 1 && variables.contains("\u03b5")) {
                JOptionPane.showMessageDialog(this.control.getMainFrame(), "No variables to replace!", "No variables to replace!", 1);
                return;
            }
            this.control.getNL().saveGraphWithoutVariables(this.control.getNL().initialGraph, false);
            this.control.getNL().loadGraph();
        } else if (e.getActionCommand().equals("entangledGraphs")) {
            this.control.addEntangledLayer();
        } else if (!e.getActionCommand().equals("adaptiveDesigns")) {
            if (e.getActionCommand().equals("bht")) {
                Hashtable<String, Object> ht = new Hashtable<String, Object>();
                ht.put("n", new int[]{1, 4, 10});
                new ParameterDialog(this.control.getGraphGUI(), ht, this, "BonferroniHolm");
            } else if (e.getActionCommand().equals("fixedSequence")) {
                Hashtable<String, Object> ht = new Hashtable<String, Object>();
                ht.put("n", new int[]{1, 4, 20});
                new ParameterDialog(this.control.getGraphGUI(), ht, this, "fixedSequence");
            } else if (e.getActionCommand().equals("fallback")) {
                Hashtable<String, Object> ht = new Hashtable<String, Object>();
                ht.put("n", new int[]{1, 4, 20});
                ht.put("weights", new double[]{0.25, 0.25, 0.25, 0.25});
                new ParameterDialog(this.control.getGraphGUI(), ht, this, "fallback");
            } else if (e.getActionCommand().equals("pg")) {
                this.loadGraph("parallelGatekeeping()");
            } else if (e.getActionCommand().equals("pgi")) {
                this.loadGraph("improvedParallelGatekeeping()");
            } else if (e.getActionCommand().equals("bauer")) {
                this.loadGraph("BauerEtAl2001()");
            } else if (e.getActionCommand().equals("bretzEtAl")) {
                this.loadGraph("BretzEtAl2011()");
            } else if (e.getActionCommand().equals("bretzEtAl2009a")) {
                this.loadGraph("BretzEtAl2009a()");
            } else if (e.getActionCommand().equals("bretzEtAl2009b")) {
                this.loadGraph("BretzEtAl2009b()");
            } else if (e.getActionCommand().equals("bretzEtAl2009c")) {
                this.loadGraph("BretzEtAl2009c()");
            } else if (e.getActionCommand().equals("hommelEtAl")) {
                this.loadGraph("HommelEtAl2007()");
            } else if (e.getActionCommand().equals("hommelEtAlSimple")) {
                this.loadGraph("HommelEtAl2007Simple()");
            } else if (e.getActionCommand().equals("hung")) {
                this.loadGraph("HungEtWang2010()");
            } else if (e.getActionCommand().equals("huque")) {
                this.loadGraph("HuqueAloshEtBhore2011()");
            } else if (e.getActionCommand().equals("maurer1995")) {
                this.loadGraph("MaurerEtAl1995()");
            } else if (e.getActionCommand().equals("truncHolm")) {
                this.loadGraph("truncatedHolm()");
            } else if (e.getActionCommand().equals("gSuccessive")) {
                this.loadGraph("generalSuccessive()");
            } else if (e.getActionCommand().equals("successiveI")) {
                this.loadGraph("simpleSuccessiveI()");
            } else if (e.getActionCommand().equals("successiveII")) {
                this.loadGraph("simpleSuccessiveII()");
            } else if (e.getActionCommand().equals("fallbackI")) {
                this.loadGraph("improvedFallbackI()");
            } else if (e.getActionCommand().equals("fallbackII")) {
                this.loadGraph("improvedFallbackII()");
            } else if (e.getActionCommand().equals("ferber2011")) {
                this.loadGraph("Ferber2011()");
            } else if (e.getActionCommand().equals("entangled1")) {
                this.loadGraph("Entangled1Maurer2012()");
            } else if (e.getActionCommand().equals("entangled2")) {
                this.loadGraph("Entangled2Maurer2012()");
            } else if (e.getActionCommand().equals("ferber2011b")) {
                Hashtable<String, Object> ht = new Hashtable<String, Object>();
                ht.put("times", new int[]{1, 5, 20});
                ht.put("doses", new int[]{1, 3, 20});
                new ParameterDialog(this.control.getGraphGUI(), ht, this, "FerberTimeDose2011");
            }
        }
    }

    private void submitGraph() {
        new GraphSendToArchiveDialog(this.control.getMainFrame(), this.control);
    }

    private void showURL(String url) {
        block2: {
            try {
                Method main = Class.forName("java.awt.Desktop").getDeclaredMethod("getDesktop", new Class[0]);
                Object obj = main.invoke((Object)new Object[0], new Object[0]);
                Method second = obj.getClass().getDeclaredMethod("browse", URI.class);
                second.invoke(obj, new URI(url));
            }
            catch (Exception exc) {
                logger.warn((Object)"No Desktop class in Java 5 or URI error.");
                RControl.getR().eval("browseURL(\"" + url + "\")");
                if (System.getProperty("eclipse") == null) break block2;
                exc.printStackTrace();
            }
        }
    }

    private void notYetSupported() {
        JOptionPane.showMessageDialog(this.control.getMainFrame(), "Not yet supported.", "Not yet supported", 1);
    }

    public void showFile(String s) {
        block16: {
            File f = new File(RControl.getR().eval("system.file(\"" + s + "\", package=\"gMCP\")").asRChar().getData()[0]);
            if (OSTools.isWindows() && s.indexOf(46) == -1) {
                try {
                    f = FileTransfer.copyFile((File)f, (File)new File(System.getProperty("java.io.tmpdir"), f.getName() + "TXT"));
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this.control.getMainFrame(), "Please open and read the following file:\n" + f.getAbsolutePath(), "Could not find appropriate viewer", 2);
                }
            }
            if (!f.exists()) {
                throw new RuntimeException("This is strange. The file \"" + s + "\" could not be found.");
            }
            try {
                Method main = Class.forName("java.awt.Desktop").getDeclaredMethod("getDesktop", new Class[0]);
                Object obj = main.invoke((Object)new Object[0], new Object[0]);
                Method second = obj.getClass().getDeclaredMethod("open", File.class);
                second.invoke(obj, f);
            }
            catch (Exception exc) {
                logger.warn((Object)("No Desktop class in Java 5 or URI error: " + exc.getMessage()), (Throwable)exc);
                if (f.getName().toLowerCase().endsWith(".html") || f.getName().toLowerCase().endsWith(".htm")) {
                    RControl.getR().eval("browseURL(\"file://" + f.getAbsolutePath().replace('\\', '/') + "\")");
                    return;
                }
                try {
                    if (OSTools.isWindows()) {
                        Process p = Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler \"" + f.getAbsolutePath() + "\"");
                        p.waitFor();
                    } else {
                        boolean opened = false;
                        for (String pdfViewer : this.pdfViewers) {
                            try {
                                if (!opened) {
                                    Runtime.getRuntime().exec(pdfViewer + " " + f.getAbsolutePath());
                                }
                                opened = true;
                            }
                            catch (Exception ePDF) {
                                // empty catch block
                            }
                        }
                        if (!opened) {
                            JOptionPane.showMessageDialog(this.control.getMainFrame(), "Please open and read the following file:\n" + f.getAbsolutePath(), "Could not find appropriate viewer", 2);
                        }
                    }
                }
                catch (Exception e1) {
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                    JOptionPane.showMessageDialog(this.control.getMainFrame(), "Please open and read the following file:\n" + f.getAbsolutePath(), "Could not find appropriate viewer", 2);
                    if (System.getProperty("eclipse") == null) break block16;
                    e1.printStackTrace();
                }
            }
        }
    }

    public void exportLaTeXReport() {
        if (this.control.getNL().getNodes().size() == 0) {
            JOptionPane.showMessageDialog(this.control.getMainFrame(), "Can not create report for empty graph.", "Can not create report for empty graph.", 0);
            return;
        }
        if (!RControl.getR().eval("exists(\"" + this.control.getNL().initialGraph + "\")").asRLogical().getData()[0]) {
            this.control.getNL().saveGraph();
        }
        JFileChooser fc = new JFileChooser(Configuration.getInstance().getClassProperty(this.getClass(), "LaTeXReportDirectory"));
        fc.setDialogType(1);
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            this.f = fc.getSelectedFile();
            Configuration.getInstance().setClassProperty(this.getClass(), "LaTeXReportDirectory", this.f.getParent());
            if (!this.f.getName().toLowerCase().endsWith(".tex")) {
                this.f = new File(this.f.getAbsolutePath() + ".tex");
            }
        } else {
            return;
        }
        logger.info((Object)("Export to: " + this.f.getAbsolutePath() + "."));
        this.control.getMainFrame().glassPane.start();
        this.correlation = this.control.getPView().getParameters();
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            protected Void doInBackground() throws Exception {
                if (!MenuBarMGraph.this.control.isResultUpToDate()) {
                    RControl.getR().evalVoid(MenuBarMGraph.this.control.result + " <- gMCP(" + MenuBarMGraph.this.control.getNL().initialGraph + MenuBarMGraph.this.control.getGMCPOptions() + ")");
                    MenuBarMGraph.this.control.setResultUpToDate(true);
                }
                String filename = MenuBarMGraph.this.f.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\");
                RControl.getR().eval("gMCPReport(" + MenuBarMGraph.this.control.result + ", file=\"" + filename + "\")");
                MenuBarMGraph.this.control.getMainFrame().glassPane.stop();
                return null;
            }
        };
        worker.execute();
    }

    public void writeLaTeX(String s) {
        block5: {
            File f;
            JFileChooser fc = new JFileChooser(Configuration.getInstance().getClassProperty(this.getClass(), "LaTeXDirectory"));
            fc.setDialogType(1);
            int returnVal = fc.showSaveDialog(this);
            if (returnVal == 0) {
                f = fc.getSelectedFile();
                Configuration.getInstance().setClassProperty(this.getClass(), "LaTeXDirectory", f.getParent());
                if (!f.getName().toLowerCase().endsWith(".tex")) {
                    f = new File(f.getAbsolutePath() + ".tex");
                }
            } else {
                return;
            }
            logger.info((Object)("Export to: " + f.getAbsolutePath() + "."));
            try {
                FileWriter out = new FileWriter(f);
                out.write(this.LATEX_BEGIN_DOCUMENT);
                out.write(s);
                out.write(this.LATEX_END_DOCUMENT);
                out.close();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Saving LaTeX code to '" + f.getAbsolutePath() + "' failed: " + ex.getMessage(), "Saving failed.", 0);
                if (System.getProperty("eclipse") == null) break block5;
                ex.printStackTrace();
            }
        }
    }

    public void exportLaTeXGraph() {
        if (this.control.getNL().getNodes().size() == 0) {
            JOptionPane.showMessageDialog(this.control.getMainFrame(), "No LaTeX output for empty graph.", "No LaTeX output for empty graph.", 0);
            return;
        }
        this.writeLaTeX(this.control.getNL().getLaTeX());
    }

    public void showLaTeXGraph() {
        if (this.control.getNL().getNodes().size() == 0) {
            JOptionPane.showMessageDialog(this.control.getMainFrame(), "No LaTeX output for empty graph.", "No LaTeX output for empty graph.", 0);
            return;
        }
        String latexCode = this.control.getNL().getLaTeX();
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(latexCode), null);
        new TextFileViewer((JFrame)this.control.getGraphGUI(), "LaTeX code", latexCode, "Also add the following lines to the header of your LaTeX file:\n\\usepackage{tikz}\n\\usetikzlibrary{decorations,arrows,shapes}");
    }

    private void saveGraphImage() {
        if (this.control.getNL().getNodes().size() == 0) {
            JOptionPane.showMessageDialog(this.control.getMainFrame(), "Will not save empty graph.", "Empty graph", 0);
            return;
        }
        JFileChooser fc = new JFileChooser(Configuration.getInstance().getClassProperty(this.getClass(), "ImageDirectory"));
        fc.setFileSelectionMode(0);
        fc.setDialogType(1);
        fc.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().toLowerCase().endsWith(".png");
            }

            public String getDescription() {
                return "PNG image files";
            }
        });
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File f = fc.getSelectedFile();
            Configuration.getInstance().setClassProperty(this.getClass(), "ImageDirectory", f.getParent());
            if (!f.getName().toLowerCase().endsWith(".png")) {
                f = new File(f.getAbsolutePath() + ".png");
            }
            this.control.saveGraphImage(f);
        }
    }

    private void loadGraph() {
        JFileChooser fc = new JFileChooser(Configuration.getInstance().getClassProperty(this.getClass(), "RObjDirectory"));
        fc.setFileSelectionMode(0);
        fc.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().toLowerCase().endsWith(".rdata");
            }

            public String getDescription() {
                return "RData files";
            }
        });
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File f = fc.getSelectedFile();
            this.loadGraph(f);
        }
        this.control.getMainFrame().validate();
    }

    private void loadGraph(File f) {
        block2: {
            this.control.stopTesting();
            Configuration.getInstance().setClassProperty(this.getClass(), "RObjDirectory", f.getParent());
            try {
                String filename = f.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\");
                String loadedGraph = RControl.getR().eval("load(file=\"" + filename + "\")").asRChar().getData()[0];
                RControl.getR().eval(loadedGraph + "<- gMCP:::updateGraphToNewClassDefinition(" + loadedGraph + ")");
                this.loadGraph(loadedGraph);
                Configuration.getInstance().getGeneralConfig().addGraph(f.getAbsolutePath());
                this.createLastUsed();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Loading graph from '" + f.getAbsolutePath() + "' failed: " + ex.getMessage(), "Loading failed.", 0);
                if (System.getProperty("eclipse") == null) break block2;
                ex.printStackTrace();
            }
        }
    }

    protected JMenuItem makeMenuItem(String text, String action) {
        return this.makeMenuItem(text, action, true);
    }

    protected JMenuItem makeMenuItem(String text, String action, boolean enabled) {
        JMenuItem item = new JMenuItem(text);
        item.setActionCommand(action);
        item.setEnabled(enabled);
        item.addActionListener(this);
        return item;
    }
}

