% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grain-main.R
\name{grain-main}
\alias{grain}
\alias{grain-main}
\alias{grain.CPTspec}
\alias{grain.POTspec}
\alias{grain.dModel}
\alias{grain.graphNEL}
\alias{iplot.grain}
\alias{is.grain}
\alias{plot.grain}
\title{Graphical Independence Network}
\usage{
grain(x, data = NULL, control = list(), smooth = 0, details = 0, ...)

\method{grain}{CPTspec}(x, data = NULL, control = list(), smooth = 0,
  details = 0, ...)

\method{grain}{POTspec}(x, data = NULL, control = list(), smooth = 0,
  details = 0, ...)

\method{grain}{graphNEL}(x, data = NULL, control = list(), smooth = 0,
  details = 0, ...)

\method{grain}{dModel}(x, data = NULL, control = list(), smooth = 0,
  details = 0, ...)

is.grain(object)
}
\arguments{
\item{x}{An argument to build an independence network
from. Typically a list of conditional probability tables, a DAG
or an undirected graph. In the two latter cases, data must also
be provided.}

\item{data}{An optional data set (currently must be an array/table)}

\item{control}{A list defining controls, see 'details' below.}

\item{smooth}{A (usually small) number to add to the counts of a
table if the grain is built from a graph plus a dataset.}

\item{details}{Debugging information.}

\item{...}{Additional arguments, currently not used.}

\item{object}{Any R object.}
}
\value{
An object of class "grain"
}
\description{
The 'grain' builds a graphical independence network.
}
\details{
If 'smooth' is non-zero then entries of 'values' which a
    zero are replaced by the value of 'smooth' - BEFORE any
    normalization takes place.
}
\examples{

## Asia (chest clinic) example:
yn   <- c("yes","no")
a    <- cptable(~asia,              values=c(1,99), levels=yn)
t.a  <- cptable(~tub+asia,          values=c(5,95,1,99), levels=yn)
s    <- cptable(~smoke,             values=c(5,5), levels=yn)
l.s  <- cptable(~lung+smoke,        values=c(1,9,1,99), levels=yn)
b.s  <- cptable(~bronc+smoke,       values=c(6,4,3,7), levels=yn)
e.lt <- cptable(~either+lung+tub,   values=c(1,0,1,0,1,0,0,1), levels=yn)
x.e  <- cptable(~xray+either,       values=c(98,2,5,95), levels=yn)
d.be <- cptable(~dysp+bronc+either, values=c(9,1,7,3,8,2,1,9), levels=yn)
plist <- compileCPT(list(a, t.a, s, l.s, b.s, e.lt, x.e, d.be))
bn    <- grain(plist)
bn
summary(bn)
plot(bn)
bnc <- compile(bn, propagate=TRUE)

## If we want to query the joint distribution of the disease nodes,
## computations can be speeded up by forcing these nodes to be in
## the same clique of the junction tree:

bnc2 <- compile(bn, root=c("lung", "bronc", "tub"), propagate=TRUE)

system.time({
  for (i in 1:200)
    querygrain(bnc, nodes=c("lung","bronc", "tub"), type="joint")})
system.time({
  for (i in 1:200)
    querygrain(bnc2, nodes=c("lung","bronc", "tub"), type="joint")})


## Simple example - one clique only in triangulated graph:
plist.s <- compileCPT( list(a, t.a) )
bn.s <- grain( plist.s )
querygrain( bn.s )

## Simple example - disconnected network:
plist.d <- compileCPT( list(a, t.a, s) )
bn.d <- grain( plist.d )
querygrain( bn.d )


## Create network from data and graph specification.
## There are different ways:
data(HairEyeColor)
hec <- HairEyeColor
daG <- dag( ~Hair + Eye:Hair + Sex:Hair )
class( daG )
uG <- ug( ~Eye:Hair + Sex:Hair )
class( uG )

## Create directly from dag:
b1  <- grain( daG, hec )
class( b1 )

## Build model from undirected (decomposable) graph
b3  <- grain( uG, hec )
class( b3 )

}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\references{
S<f8>ren H<f8>jsgaard (2012). Graphical Independence
    Networks with the gRain Package for R. Journal of Statistical
    Software, 46(10), 1-26.
    \url{http://www.jstatsoft.org/v46/i10/}.
}
\seealso{
\code{\link{cptable}}, \code{\link{compile.grain}},
    \code{\link{propagate.grain}}, \code{\link{setFinding}},
    \code{\link{setEvidence}}, \code{\link{getFinding}},
    \code{\link{pFinding}}, \code{\link{retractFinding}}
    %\code{\link[gRbase]{gmData}}
}
\keyword{models}

