% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_array-operations.R
\name{array-operations}
\alias{\%a==\%}
\alias{\%a^\%}
\alias{\%a_\%}
\alias{ar_align}
\alias{ar_equal}
\alias{ar_expand}
\alias{ar_marg}
\alias{ar_perm}
\alias{ar_prod_list}
\alias{ar_sum_list}
\alias{array-operations}
\alias{tabAdd__}
\alias{tabAlign}
\alias{tabAlign__}
\alias{tabCondProb}
\alias{tabDiv0__}
\alias{tabDiv__}
\alias{tabEqual}
\alias{tabEqual__}
\alias{tabExpand}
\alias{tabExpand__}
\alias{tabExt}
\alias{tabListAdd}
\alias{tabListAdd__}
\alias{tabListMult}
\alias{tabListMult__}
\alias{tabMarg}
\alias{tabMarg__}
\alias{tabMult__}
\alias{tabOp__}
\alias{tabPerm}
\alias{tabPerm__}
\alias{tabSlice}
\alias{tabSlice2}
\alias{tabSlice2Entries}
\alias{tabSlice2Entries_}
\alias{tabSliceMult}
\alias{tabSlicePrim}
\alias{tabSubt__}
\title{Operations on multidimensional arrays.}
\usage{
ar_perm(tab, perm)

ar_prod_list(lst)

ar_sum_list(lst)

ar_marg(tab, marg)

ar_equal(tab1, tab2, eps = 1e-12)

tab1 \%a==\% tab2

tab1 \%a_\% marg

tab1 \%a^\% extra

ar_expand(tab1, tab2)

ar_align(tab1, tab2)
}
\arguments{
\item{tab, tab1, tab2}{Multidimensional arrays.}

\item{perm}{A vector of indices or dimnames giving the desired permutiation.}

\item{lst}{List of arrays.}

\item{marg}{Specification of marginal; either a character vector, a numeric
vector or a right hand sided formula For \code{ar_perm} and \code{ar_marg}
it can also be a right hand sided formula.}

\item{eps}{Criterion for checking equality of two arrays.}

\item{extra}{List defining the extra dimensions.}
}
\value{
Most functions here return a multidimensional array.
}
\description{
Operations like marginalize, permute, slicing etc on
    arrays A multidimensional table (an array) is here a vector
    with a dim and a dimnames attribute.
}
\details{
\code{perm} in \code{ar_perm()} can be a vector of indices
    (as in Rs own \code{aperm()}) but also a vector of
    dimnames. Currently there is no checking that the dimnames are
    actually in the array, so please take care.
}
\examples{

ar1 <- array(1:8, dim=c(2,2,2), dimnames=list("a"=1:2,"b"=1:2,"c"=1:2))
ar2 <- array(1:8, dim=c(2,2,2), dimnames=list("b"=1:2,"c"=1:2,"d"=1:2))

## ## armarg ##
## Marginalize down to the bc-array
ar_marg(ar1, 2:3)
ar_marg(ar1, c("b","c"))
ar_marg(ar1, ~b + c)

## This gives an error
## ar_marg(ar1, c(2,5))
## ar_marg(ar1, c("b","w"))
## ar_marg(ar1, ~b + w)
 
## ## ar_perm ##
ar_perm(ar1, 1:3)      ## No change - an abc-table
ar_perm(ar1, c(2,3,1)) ## A bca-table
ar_perm(ar1, ~b + c + a)

## This gives error
## ar_perm(ar1, c(2,1))
## ar_perm(ar1, c(2,1,5))
## ar_perm(ar1, c(2,1,NA))

## ## ar_mult etc ##
## Multiply two arrays
out <- ar_mult(ar1, ar2)
out <- ar_perm(out, ~a + b + c + d) ## Just for comparison below
ftable(out)
## Alternative approch
df1 <- as.data.frame.table(ar1)
df2 <- as.data.frame.table(ar2)
df3 <- merge(df1, df2, by=c("b","c"))
df3 <- transform(df3, Freq=Freq.x*Freq.y)
ar3 <- xtabs(Freq ~ a + b + c + d, data=df3)
ftable(ar3)

## ## ar_expand ##
ar1.e <- ar_expand(ar1, ar2)
## ar1.e has dimnames b,c,d,a; values are simply replicated for each
## level of d.
dimnames(ar1.e)
ftable(ar1.e, row.vars="d")

## ## aralign ##
ar2.e <- ar_expand(ar2, ar1)
names(dimnames(ar2.e))
names(dimnames(ar1.e))
out <- ar_align(ar1.e, ar2.e)
names(dimnames(out)) ## Same as ar2.e


aa = ar_new(~a, levels=2, values=c(1,100))
ar_expand(aa, list(b=1:2))
aa \%a^\% list(b=1:2)

## ar_expand:
ar1 <- array(1:8, dim=c(2,2,2), dimnames=list("a"=1:2,"b"=1:2,"c"=1:2))
ar2 <- array(1:8, dim=c(2,2,2), dimnames=list("b"=1:2,"c"=1:2,"d"=1:2))

ar_expand(ar1, ar2) \%>\% ftable(row.vars=1) ## Same as
## ar_expand(ar1, dimnames(ar2)) \%>\% ftable(row.vars=1) 
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\seealso{
\code{\link{aperm}}, \code{\link{ar_perm}}, \code{\link{ar_slice}},
    \code{\link{ar_slice_entries}}
}
\keyword{utilities}

