% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglin-effloglin.R
\name{loglin-effloglin}
\alias{loglin-effloglin}
\alias{effloglin}
\title{Fitting Log-Linear Models by Message Passing}
\usage{
effloglin(table, margin, fit = FALSE, eps = 0.01, iter = 20, print = TRUE)
}
\arguments{
\item{table}{A contingency table}

\item{margin}{A generating class for a hierarchical log--linear model}

\item{fit}{If TRUE, the fitted values are returned.}

\item{eps}{Convergence limit; see 'details' below.}

\item{iter}{Maximum number of iterations allowed}

\item{print}{If TRUE, iteration details are printed.}
}
\value{
A list.
}
\description{
Fit log-linear models to multidimensional contingency
tables by Iterative Proportional Fitting.
}
\details{
The function differs from \code{loglin} in that 1) data
can be given in the form of a list of sufficient marginals and
2) the model is fitted only on the cliques of the triangulated
interaction graph of the model. This means that the full table
is not fitted, which means that \code{effloglin} is efficient
(in terms of storage requirements). However \code{effloglin} is
implemented entirely in R and is therefore slower than
\code{loglin}. Argument names are chosen so as to match those
of loglin()
}
\examples{

data(reinis)
glist <-list(c("smoke", "mental"), c("mental", "phys"),
             c("phys", "systol"), c("systol", "smoke"))

stab <- lapply(glist, function(gg) tabMarg(reinis, gg))
fv3 <- effloglin(stab, glist, print=FALSE)

}
\references{
Radim Jirousek and Stanislav Preucil (1995). On the
effective implementation of the iterative proportional fitting
procedure. Computational Statistics & Data Analysis Volume 19,
Issue 2, February 1995, Pages 177-189
}
\seealso{
\code{\link{loglin}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{models}
