% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.sgSEMp2.R
\name{plot.sgSEMp2}
\alias{plot.sgSEMp2}
\title{Plotting of Principle 2 of Semi-gSEM}
\usage{
\method{plot}{sgSEMp2}(x, ..., cutoff = 0.2, width = NULL, height = NULL,
  filename = NULL)
}
\arguments{
\item{x}{The returned list from sgSEMp2. Plotting uses the first element of this list (print) in which the first column of it is the response, the second column is variable and other columns are corresponding statistical model, r-squared, adj-r-squared, P-value, P-value rank, p1ff, r2mark, and markrank.}

\item{...}{Other parameters. Currently not used.}

\item{cutoff}{A threshold value for the adjusted R-squared. Solid lines represent a relationship with adjusted R-sqr of greater than the cutoff and dotted lines with less than the cutoff. The default is 0.2.}

\item{width}{A numeric describing the width of the plot output in pixels.}

\item{height}{A numeric describing the height of the plot output in pixels.}

\item{filename}{A character string naming a file to save as an html file.}
}
\value{
An html style plot of the pairwise relationship pathway diagram between stressors and responses. Arrows show relationships between each variable with given statistical relations along the connection lines.
}
\description{
plot.sgSEMp2 plots a structural equation network model diagram based on best functional form for additive pairwise relationships.
}
\examples{
data(acrylic)
ans <- sgSEMp2(acrylic)
plot(ans, cutoff = 0.2)
}
\keyword{2,}
\keyword{Semi-gSEM,}
\keyword{diagram}
\keyword{network}
\keyword{pathway}
\keyword{principle}

