\name{gprogressbar}
\alias{.gprogressbar}
\alias{gprogressbar}
\title{Basic progress bar widget}
\usage{
  gprogressbar(value = 10, container = NULL, ...,
    toolkit = guiToolkit())

  .gprogressbar(toolkit, value, container, ...)
}
\arguments{
  \item{value}{Initial value, between 0 and 100. A value of
  \code{NULL} will make pulsing bar with indeterminate
  state. For some toolkits, this must be called
  periodically to pulse the bar.}

  \item{container}{A parent container. When a widget is
  created it can be incorporated into the widget heirarchy
  by passing in a parent container at construction time.
  (For some toolkits this is not optional, e.g.
  \pkg{gWidgets2tcltk} or \pkg{gWidgets2WWW2}.)}

  \item{...}{These values are passed to the \code{add}
  method of the parent container, and occasionally have
  been used to sneak in hidden arguments to toolkit
  implementations. For example, when using a widget as a
  menubar object one can specify a parent argument to pass
  in parent information, similar to how the argument is
  used with gaction and the dialogs.}

  \item{toolkit}{Each widget constructor is passed in the
  toolkit it will use. This is typically done using the
  default, which will lookup the toolkit through
  \code{\link{guiToolkit}}.}
}
\value{
  a \code{GButton} instance. While this object has its own
  (reference) methods, one primarily interacts with it
  through S3 methods defined within the package.
}
\description{
  Basic progress bar widget

  S3 generic whose methods are implemented in the toolkit
  packages
}

