% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isotope-maneuvers.R
\name{extract_isopredictions}
\alias{extract_isopredictions}
\title{Add the isomap prediction and sd in columns attached to the feather isotope data frame}
\usage{
extract_isopredictions(isoscape, birds, pred = "predkrig", sd = "stdkrig")
}
\arguments{
\item{isoscape}{the data frame of prediction.txt from ISOMAP.  The latitude column must be named
"lat" and the longitude column must be named "long".}

\item{birds}{data frame of the individual isotope values for the birds/feathers.  Should be
something like \code{\link{breeding_wiwa_isotopes}}.}

\item{pred}{name of the column holding the prediction (like "predkrig") in the
isoscape data frame}

\item{sd}{name of the column holding the standard deviation (like "stdkrig") in the
isoscape data frame}
}
\description{
Rasterizes the isomap predictions and standard deviation (using isomap2raster) and then extracts
the values associated with each location from the raster and returns the full data frame
with those values joined on in columns named iso_pred and iso_sd.  It overwrites
those columns with a warning if either of those columns already exists in the data.
}
\examples{
# Using the provided data from breeding Wilson's warblers and the provided
# predictions from isomap_job54152:
x <- extract_isopredictions(isoscape = isomap_job54152_prediction,
                       birds = breeding_wiwa_isotopes,
                       pred = "predkrig",
                       sd = "stdkrig")
}

