% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess.R
\name{min_hpd_inc_area_df}
\alias{min_hpd_inc_area_df}
\title{compute the minimum hpd inclusion area for all the birds in a rasterStack}
\usage{
min_hpd_inc_area_df(birds, R)
}
\arguments{
\item{birds}{a data frame that minimally has columns \code{Short_Name}, \code{lat}, and
\code{long}.}

\item{R}{a rasterStack or rasterBrick of posteriors that each bird originated from
each of the cells.  The names of the layers must correspond to the ID column in
kbirds.}
}
\value{
This returns a list with three components:
\itemize{
\item{area} {the minimum hpd inclusion area as a data frame with columns "Short_Name" and "min_hpd_area"}
\item{missingFromRaster}{character vector of the names of birds found in birds$Short_Name but not found in
the names of R}
\item{missingFromDF}{ character vector of names in R that are not found in birds$Short_Name.}
}
}
\description{
This is a convenient wrapper that lets you pass in a data frame of bird
names with lats and longs and a rasterStack or rasterBrick and it returns
the min hpd inclusion area for each bird in a tbl_df-ed data frame.
}
\keyword{internal}

