% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vander-zanden-appendix.R
\name{vza_mean_and_var_rasters}
\alias{vza_mean_and_var_rasters}
\title{calculate a raster of mean and variance of expected tissue isotopes from precip data and resampled regressions}
\usage{
vza_mean_and_var_rasters(iso_raster, si)
}
\arguments{
\item{iso_raster}{the raster of isotope precipitation values, for example, like that
produced by \code{\link{isomap2raster}}.}

\item{si}{slopes and intercepts from the resampled regressions.  This is a data frame
with columns named "slopes" and "intercepts" like that returned by \code{\link{vza_rescale}}}
}
\description{
This is a rewrite of the function \code{raster.conversion} from the Vander Zanden
appendix.  They expressed things in terms of the standard deviations, but they need to
be turned into variances, anyway, so that is what we've done here.  Following the notation
of the paper on Wilson's warbler, this function computes $tilde{T}^{(mu)}$ (returned as
list component \code{mean.raster}) and $R^{(sigma^2)}$ (returned as list component
\code{var.raster})
}
\keyword{internal}

