% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_locations.R
\name{select_locations}
\alias{select_locations}
\title{Build a WKT string from an sf spatial object or verify an existing WKT}
\usage{
select_locations(sf, wkt)
}
\arguments{
\item{sf}{sf object: area to be converted to wkt}

\item{wkt}{string: wkt to be verified. WKT strings longer than 10000
characters will not be accepted by the ALA- see the vignette for how to
work around this.}
}
\value{
WKT string representing the area provided.
}
\description{
Restrict results to those from a specified area. Areas must be polygons
and be specified as either an sf object, or a 'well-known text' (wkt) string.
}
\examples{
\dontrun{
# Search for records using a shapefile
locations <- select_locations(sf = path/to/shapefile)
ala_occurrences(locations = locations)

# Search for records using a WKT
wkt <- "POLYGON((142.36228 -29.00703,142.74131 -29.00703,142.74131 \
-29.39064,142.36228 -29.39064,142.36228 -29.00703))"
ala_occurrences(wkt = select_locations(wkt = wkt))
}

}
\seealso{
\code{\link{select_taxa}}, \code{\link{select_filters}} and
\code{\link{select_columns}} for other ways to restrict the information returned
by \code{\link{ala_occurrences}} and related functions.
}
