% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooths.R
\name{t2}
\alias{t2}
\alias{t2l}
\title{Set up smooth term with factor loading}
\usage{
t2l(..., factor = NULL)
}
\arguments{
\item{...}{Arguments passed on to \code{mgcv::t2}.}

\item{factor}{Optional character argument specifying the loading variable.}
}
\value{
An object of class \code{xx.smooth.spec}, where \code{xx} is a basis
identifying code given by the \code{bs} argument of \code{t2}.
It differs from the smooth returned by \code{mgcv::s} in
that it has an additional attribute named \code{"factor"} which specifies
any factor loading which this smooth term should be multiplied with in
order to produce the observed outcome.
}
\description{
This is a very thin wrapper around \code{mgcv::t2}. It enables the
specification of loading variables for smooth terms. The last letter "l",
which stands for "loading", has been added to avoid namespace conflicts
with \code{mgcv} and \code{gamm4}.
}
\examples{
# Linear mixed model with factor structures
dat <- subset(cognition, domain == 1 & timepoint == 1)
loading_matrix <- matrix(c(1, NA, NA), ncol = 1)

# Model with four cubic regression splines as basis functions
mod <- galamm(
  formula = y ~ 0 + item + t2l(x, k = 4, factor = "loading"),
  data = dat,
  load.var = "item",
  lambda = list(loading_matrix),
  factor = list("loading")
)

# Model with four thin-plate regression splines as basis functions
mod <- galamm(
  formula = y ~ 0 + item +
    t2l(x, bs = "tp", k = 4, factor = "loading"),
  data = dat,
  load.var = "item",
  lambda = list(loading_matrix),
  factor = list("loading")
)

}
\references{
\insertRef{woodThinPlateRegression2003}{galamm}

\insertRef{woodGeneralizedAdditiveModels2017a}{galamm}
}
\seealso{
Other modeling functions: 
\code{\link{galamm}()},
\code{\link{s}()}
}
\concept{modeling functions}
