% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AICc.R, R/BIC.R, R/logLik_gambin.R
\name{AIC.gambin}
\alias{AIC.gambin}
\alias{AICc}
\alias{AICc.gambin}
\alias{BIC.gambin}
\alias{logLik.gambin}
\title{Likelihood statistics for the GamBin model}
\usage{
\method{AIC}{gambin}(object, ...)

AICc(object, ...)

\method{AICc}{gambin}(object, ...)

\method{BIC}{gambin}(object, ...)

\method{logLik}{gambin}(object, ...)
}
\arguments{
\item{object}{An object of type \code{gambin}}

\item{\dots}{Further arguments to pass to the function}
}
\value{
logLik returns an R object of type \code{logLik}. The other function return the numerical value of the statistic
}
\description{
Uses likelihood and information theoretical approaches to reveal
the degree of fit of the GamBin model to empirical species abundance distributions.
}
\examples{
data(moths)
fit = fit_abundances(moths)
AIC(fit)
}
\references{
Akaike, Hirotugu. "A new look at the statistical model identification." Automatic Control,
IEEE Transactions on 19.6 (1974): 716-723.
}
