% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/peaks_find.R
\docType{methods}
\name{peaks_find}
\alias{peaks_find}
\alias{peaks_find-method}
\alias{peaks_find,GammaSpectrum-method}
\title{Peaks}
\usage{
peaks_find(object, ...)

\S4method{peaks_find}{GammaSpectrum}(object, method = c("MAD"), SNR = 2, span = NULL, ...)
}
\arguments{
\item{object}{A \linkS4class{GammaSpectrum} or \linkS4class{PeakPosition}
object.}

\item{...}{Extra parameters to be passed to internal methods.}

\item{method}{A \code{\link{character}} string specifying the method to be
used for background noise estimation (see below).}

\item{SNR}{An \code{\link{integer}} giving the signal-to-noise-ratio for
peak detection (see below).}

\item{span}{An \code{\link{integer}} giving the half window size (in number
of channels). If \code{NULL}, 5\% of the number of channels is used as the
half window size.}
}
\value{
An object of class \linkS4class{PeakPosition}.
}
\description{
Finds local maxima in sequential data.
}
\details{
A local maximum has to be the highest one in the given window and has to be
 higher than \eqn{SNR \times noise}{SNR * noise} to be recognized as peak.

 The following methods are available for noise estimation:
 \describe{
  \item{MAD}{Median Absolute Deviation.}
 }
}
\examples{
## Import a Canberra CNF file
spc_file <- system.file("extdata/LaBr.CNF", package = "gamma")
spc <- read(spc_file)

## Find peaks
(pks <- peaks_find(spc))
plot(spc, pks)
}
\seealso{
Other signal processing: 
\code{\link{baseline}},
\code{\link{signal_integrate}()},
\code{\link{signal_slice}()},
\code{\link{signal_stabilize}()},
\code{\link{smooth}()}
}
\author{
N. Frerebeau
}
\concept{signal processing}
