% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/signal_slice.R
\docType{methods}
\name{signal_slice}
\alias{signal_slice}
\alias{signal_slice-method}
\alias{signal_slice,GammaSpectrum-method}
\alias{signal_slice,GammaSpectra-method}
\title{Choose channels by Position}
\usage{
signal_slice(object, ...)

\S4method{signal_slice}{GammaSpectrum}(object, ...)

\S4method{signal_slice}{GammaSpectra}(object, ...)
}
\arguments{
\item{object}{A \linkS4class{GammaSpectrum} or \linkS4class{GammaSpectra}
object.}

\item{...}{\code{\link{integer}} values giving the channels of the spectrum to be
kept/dropped (see below). Numeric values are coerced to integer as by
\code{\link[=as.integer]{as.integer()}} (and hence truncated towards zero).}
}
\value{
A \linkS4class{GammaSpectrum} or \linkS4class{GammaSpectra} object.
}
\description{
Choose channels by position.
}
\details{
Either positive values to keep, or negative values to drop, should be
provided. The values provided must be either all positive or all negative.

If no value is provided, an attempt is made to define the number
of channels to skip at the beginning of the spectrum. This drops all
channels before the highest count maximum. This is intended to deal with the
artefact produced by the rapid growth of random background noise towards low
energies.
}
\examples{
## Import CNF files
spc_file <- system.file("extdata/LaBr.CNF", package = "gamma")
spc <- read(spc_file)

## Plot spectrum
plot(spc)

## Slice
sliced <- signal_slice(spc)
plot(sliced)

sliced <- signal_slice(spc, -c(1:35))
plot(sliced)

sliced <- signal_slice(sliced, 450:550)
plot(sliced)

## Split
g <- rep(c("A", "B", "C"), c(250, 500, 274))
splited <- signal_split(spc, g)
plot(splited, facet = TRUE)
}
\seealso{
Other signal processing: 
\code{\link{baseline}},
\code{\link{peaks_find}()},
\code{\link{peaks_search}()},
\code{\link{signal_integrate}()},
\code{\link{signal_split}()},
\code{\link{signal_stabilize}()},
\code{\link{smooth}()}
}
\author{
N. Frerebeau
}
\concept{signal processing}
