% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Segment-generics.R, R/Segment-methods.R
\docType{methods}
\name{DynSegment}
\alias{DynSegment}
\alias{DynSegment,ANY-method}
\alias{DynSegment,gaDynSegment-method}
\title{DynSegment.}
\usage{
DynSegment(object, ..., name = character(0))

\S4method{DynSegment}{ANY}(object, ..., name = character(0))

\S4method{DynSegment}{gaDynSegment}(object)
}
\arguments{
\item{object}{The first filter to include in the segment definition.}

\item{...}{Additional filters to include in the segment definition, if
needed.}

\item{name}{An optional name given to the dynamic segment.}
}
\value{
a gaDynSegment object.
}
\description{
Combine one or more segment condition filters and/or sequence filters into a
gaDynSegment that is scoped to either 'user' or 'session' level.
}
\details{
A segment filter is either sequential or non-sequential conditions.
Sequential and non-sequential conditions can be combined using this function.
}
\section{Methods (by class)}{
\itemize{
\item \code{ANY}: Defines a list of filters from one or more
expressions applied using the specified scope.

\item \code{gaDynSegment}: Returns itself.
}}

