C FILE "PATH3.INC" =====================================================
C COMMON BLOCKS USED IN THE PATH3A AND PATH3B PROGRAMS

C VARIABLES IN COMMON BLOCK /FAMDAT/:
C     NGROUP -- NUMBER OF CATEGORIES (I.E. PF,IF,PM,IM,PC,IC,PCA,ICA) OF
C               OBSERVATIONS
C     MAXFAM -- UPPER LIMIT ON THE NUMBER OF FAMILIES
C     MAXOBS -- UPPER LIMIT ON THE TOTAL NUMBER OF OBSERVATIONS
C     XOBS   -- LINEARIZED LIST OF QUANTITATIVE OBSERVATIONS
C     NLINK  -- COUNTS OF THE NUMBER OF OBSERVATIONS BY CATEGORY WITHIN
C               EACH FAMILY
C     NFAM   -- NUMBER OF FAMILIES

      PARAMETER (NGROUP=6, MAXFAM=5000, MAXOBS=20000)
      INTEGER           NFAM
      INTEGER           NLINK(NGROUP,MAXFAM)
      REAL              XOBS(MAXOBS)
      COMMON /FAMDAT/   XOBS, NLINK, NFAM

C VARIABLES IN COMMON BLOCK /CORDAT/:
C     RHO    -- MATRIX OF EXPECTED CORRELATIONS AMONG ALL CATEGORIES

      DOUBLE PRECISION  RHO(NGROUP,NGROUP)
      COMMON /CORDAT/   RHO

C VARIABLES IN COMMON BLOCK /POSDEF/:
C     IPD    --- NUMBER OF SIGMA MATRICES FOUND TO BE NON
C                POSITIVE-DEFINITE AT THE PREVIOUS FUNCTION EVALUATION

      INTEGER           IPD
      COMMON /POSDEF/   IPD

C VARIABLES IN COMMON BLOCK /GOF/:
C     GOFOUT -- FLAG INDICATING WHEN TO WRITE THE GOODNESS OF FIT TABLE
C     LFNGOF -- OUTPUT UNIT TO USE WHEN WRITING GOF TABLE

      LOGICAL           GOFOUT
      INTEGER           LFNGOF
      COMMON /GOF/      GOFOUT, LFNGOF

C END OF FILE "PATH3.INC" ==============================================
