% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SNP.R
\name{snp.ES}
\alias{snp.ES}
\alias{snp.HWE}
\alias{PARn}
\alias{snp.PAR}
\title{Functions for single nucleotide polymorphisms (SNPs)}
\usage{
snp.ES(beta, SE, N)

snp.HWE(g)

PARn(p, RRlist)

snp.PAR(RR, MAF, unit = 2)
}
\arguments{
\item{beta}{Regression coefficient.}

\item{SE}{Standard error for beta.}

\item{N}{Sample size.}

\item{g}{Observed genotype vector.}

\item{p}{genotype frequencies.}

\item{RRlist}{A list of RRs.}

\item{RR}{Relative risk.}

\item{MAF}{Minar allele frequency.}

\item{unit}{Unit to exponentiate for homozygote.}
}
\description{
Eventually, this will be a set of functions specifically for single
nucleotide polymorphisms (SNPs), which are biallelic markers. This
is particularly relevant to the genomewide association studies (GWAS)
using GeneChips and in line with the classic generalised single-locus
model. snp.HWE is from Abecasis's website and yet to be adapted for 
chromosome X.
}
\details{
snp.ES provides effect size estimates based on the linear regression coefficient and standard error.
For logistic regression, we can have similar idea for log(OR) and log(SE(OR)).

snp.HWE gives an exact Hardy-Weinberg Equilibrium (HWE) test and it return -1 in the case of misspecification of genotype counts.

snp.PAR calculates the the population attributable risk (PAR) for a particular SNP.
Internally, it calls for an internal function PARn, given a 
set of frequencies and associate relative risks (RR). Other
2x2 table statistics familiar to epidemiologists can be added when
necessary.
}
\author{
Jing Hua Zhao, Shengxu Li
}
\keyword{utilities}
