% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gapfill.R
\name{EstimateQuantile}
\alias{EstimateQuantile}
\title{Estimate the Quantile of a Missing Value}
\usage{
EstimateQuantile(a, mp, nQuant, predictionInterval = FALSE)
}
\arguments{
\item{a}{Numeric array with 4 dimensions.}

\item{mp}{Integer vector of length 4 indexing the position of the
missing value to predict.}

\item{nQuant}{Integer vector of length 1. Minimum number of non-missing values in \code{a[mp[1], mp[2],,]} required to estimate the quantile.
If \code{a[mp[1], mp[2],,]} contains less non-missing values, the neighboring values of \code{a[mp[1], mp[2],,]} are also taken into account.}

\item{predictionInterval}{Logical vector of length 1.
If \code{TRUE}, the estimated quantile together with lower and upper bounds of an approximate 90\% uncertainty interval
is returned.}
}
\value{
If \code{predictionInterval} is \code{FALSE}, a numeric vector of length 1 being the estimated quantile of the missing value
\code{a[mp[1], mp[2], mp[3], mp[4]]} is returned.
Otherwise, a numeric vector of length 3 containing the estimated quantile and the lower and upper bounds of an
approximate 90\% uncertainty interval is returned.
}
\description{
Helper function for \code{\link{Predict}}.
The function estimates the quantile of the missing value at position \code{mp} from the
data \code{a} relative to its image a[,,mp[3],mp[4]].
}
\examples{
a <- Subset(data = ndvi, mp = c(1, 3, 1, 2), i = 0)
EstimateQuantile(a = a, mp = attr(a, "mp"), nQuant = 2)

}
\author{
Florian Gerber, \email{florian.gerber@math.uzh.ch}.
}
\references{
F. Gerber, R. Furrer, G. Schaepman-Strub, R. de Jong, M. E. Schaepman, 2016,
Predicting missing values in spatio-temporal satellite data.
\url{http://arxiv.org/abs/1605.01038}.
}
\seealso{
\code{\link{Predict}}.
}

