% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gargle-class.R
\name{gargle2.0_token}
\alias{gargle2.0_token}
\title{Generate a gargle token}
\usage{
gargle2.0_token(
  email = gargle_oauth_email(),
  app = gargle_app(),
  package = "gargle",
  scope = NULL,
  user_params = NULL,
  type = NULL,
  use_oob = gargle_oob_default(),
  credentials = NULL,
  cache = if (is.null(credentials)) gargle_oauth_cache() else FALSE,
  ...
)
}
\arguments{
\item{email}{Optional. Allows user to target a specific Google identity. If
specified, this is used for token lookup, i.e. to determine if a suitable
token is already available in the cache. If no such token is found, \code{email}
is used to pre-select the targetted Google identity in the OAuth chooser.
Note, however, that the email associated with a token when it's cached is
always determined from the token itself, never from this argument. Use \code{NA}
or \code{FALSE} to match nothing and force the OAuth dance in the browser. Use
\code{TRUE} to allow email auto-discovery, if exactly one matching token is
found in the cache. Defaults to the option named "gargle_oauth_email",
retrieved by \code{\link[gargle:gargle_oauth_email]{gargle::gargle_oauth_email()}}.}

\item{app}{An OAuth consumer application, created by \code{\link[httr:oauth_app]{httr::oauth_app()}}.}

\item{package}{Name of the package requesting a token. Used in messages.}

\item{scope}{A character vector of scopes to request.}

\item{user_params}{Named list holding endpoint specific parameters to pass to
the server when posting the request for obtaining or refreshing the
access token.}

\item{type}{content type used to override incorrect server response}

\item{use_oob}{Whether to prefer "out of band" authentication. Defaults to
the option named "gargle_oob_default", retrieved via
\code{\link[gargle:gargle_oob_default]{gargle::gargle_oob_default()}}.}

\item{credentials}{Advanced use only: allows you to completely customise
token generation.}

\item{cache}{Specifies the OAuth token cache. Defaults to the option named
"gargle_oauth_cache", retrieved via \code{\link[gargle:gargle_oauth_cache]{gargle::gargle_oauth_cache()}}.}

\item{...}{Absorbs arguments intended for use by other credential functions.
Not used.}
}
\value{
An object of class \link{Gargle2.0}, either new or loaded from the cache.
}
\description{
Constructor function for objects of class \link{Gargle2.0}.
}
\examples{
\dontrun{
gargle2.0_token()
}
}
